package com.suncode.plugin.dataviewer.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.dataviewer.configuration.Menu;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
class ConfigurationMenuConverter
{
    private final ObjectMapper objectMapper = new ObjectMapper();

    List<ConfigurationMenuDto> convertToDto( List<Menu> menus )
        throws JsonProcessingException
    {
        List<ConfigurationMenuDto> list = new ArrayList<>();
        for ( Menu menu : menus )
        {
            ConfigurationMenuDto configurationMenuDto = new ConfigurationMenuDto( menu.getName(), objectMapper.writeValueAsString( menu ) );
            list.add( configurationMenuDto );
        }
        return list;
    }

    List<Menu> convertToMenu( List<ConfigurationMenuDto> configurationMenuDtos )
        throws JsonProcessingException
    {
        List<Menu> list = new ArrayList<>();
        for ( ConfigurationMenuDto configurationMenuDto : configurationMenuDtos )
        {
            Menu menu = objectMapper.readValue( configurationMenuDto.getConfiguration(), Menu.class );
            list.add( menu );
        }
        return list;
    }
}
