package com.suncode.plugin.dataviewer.favourites;

import com.suncode.plugin.dataviewer.configuration.Menu;
import com.suncode.plugin.dataviewer.service.configuration.ConfigurationService;
import com.suncode.plugin.dataviewer.service.persmission.PermissionService;
import com.suncode.pwfl.favourites.FavouriteElement;
import com.suncode.pwfl.favourites.FavouriteHandler;
import com.suncode.pwfl.favourites.view.Definition;
import com.suncode.pwfl.favourites.view.FavouritesRenderer;
import com.suncode.pwfl.favourites.view.NestedDefinition;
import com.suncode.pwfl.favourites.view.Parameter;
import com.suncode.pwfl.favourites.view.support.TileDto;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component
public class DataViewerFavouritesHandler
    implements FavouriteHandler
{
    private static final String PARENT_TYPE = "data-viewer";

    private static final String TYPE = "data-viewer-menu";

    public static final int ORDER = 1000;

    private final Translator translator = Translators.get( DataViewerFavouritesHandler.class );

    @Autowired
    private ApplicationContext context;

    @Autowired
    private ConfigurationService configurationService;

    @Autowired
    private PermissionService permissionService;

    @Override
    public boolean supports( String type )
    {
        return TYPE.equals( type );
    }

    @Override
    public Collection<Definition> getDefinitions()
    {
        List<Definition> definitions = new ArrayList<>();
        definitions.add( getParentDefinition() );
        definitions.addAll( getNestedDefinitions() );
        return definitions;
    }

    private Definition getParentDefinition()
    {
        var parentDefinition = new Definition( PARENT_TYPE, ORDER );
        parentDefinition.setName( translator.getMessage( "data.viewer.favourites.parent.name" ) );
        parentDefinition.setDisplayName( translator.getMessage( "data.viewer.favourites.parent.name" ) );
        parentDefinition.setCountable( false );
        parentDefinition.setSupported( false );
        return parentDefinition;
    }

    private List<NestedDefinition> getNestedDefinitions()
    {
        return getMenusAvailableToUser().stream()
            .map( menu -> {
                      var definition = new NestedDefinition( PARENT_TYPE, TYPE );
                      definition.setName( menu.getName() );
                      definition.setDisplayName( menu.getName() );
                      definition.setDescription( translator.getMessage( "data.viewer.favourites.child.description", menu.getName() ) );
                      definition.setTypeDescription( translator.getMessage( "data.viewer.favourites.child.type" ) );
                      definition.setParameter( Parameter.nonRenderable( menu.getId() ) );
                      definition.setCountable( false );
                      return definition;
                  }
            ).toList();
    }

    private List<Menu> getMenusAvailableToUser()
    {
        return configurationService.getConfiguration()
            .getMenus()
            .stream()
            .filter( menu -> permissionService.hasPermissionToMenu( menu.getId() ) )
            .toList();
    }

    @Override
    public FavouritesRenderer getRenderer( FavouriteElement favourite )
    {
        DataViewerFavouriteRenderer renderer = context.getAutowireCapableBeanFactory().createBean( DataViewerFavouriteRenderer.class );
        renderer.setFavourite( favourite );
        return renderer;
    }

    @Override
    public FavouritesRenderer getTileRenderer( TileDto tileDto )
    {
        DataViewerFavouriteRenderer renderer = context.getAutowireCapableBeanFactory().createBean( DataViewerFavouriteRenderer.class );
        renderer.setTileDto( tileDto );
        return renderer;
    }
}