package com.suncode.plugin.dataviewer.configuration.action;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

@Data
@JsonTypeInfo( use = JsonTypeInfo.Id.NAME, property = "type", visible = true )
@JsonSubTypes( {
                @JsonSubTypes.Type( value = ShowCommentsAction.class, name = ShowCommentsAction.TYPE ),
                @JsonSubTypes.Type( value = ShowViewAction.class, name = ShowViewAction.TYPE ),
                @JsonSubTypes.Type( value = ShowActivityFormAction.class, name = ShowActivityFormAction.TYPE ),
                @JsonSubTypes.Type( value = ShowActivityDetailsAction.class, name = ShowActivityDetailsAction.TYPE ),
                @JsonSubTypes.Type( value = ShowProcessDetailsAction.class, name = ShowProcessDetailsAction.TYPE ),
                @JsonSubTypes.Type( value = OpenUrlAction.class, name = OpenUrlAction.TYPE )
} )
public abstract class Action
{
    @JsonIgnore
    private String type;
}
