package com.suncode.plugin.dataviewer.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

public enum ConditionOperator
{
    OR, AND, ISEMPTY, ISNOTEMPTY, EQ, NOTEQ, GT, LT, GE, LE;

    @JsonCreator
    public static ConditionOperator forValue( String value )
    {
        return Stream.of( values() )
            .filter( type -> type.value().equals( value ) )
            .findFirst()
            .orElseThrow( RuntimeException::new );
    }

    @JsonValue
    public String value()
    {
        return name().toLowerCase();
    }
}
