PWE.integrationComponent.registerDataChooser('enova.contractors.dc', {
    apiVersion: 2,
    buildForm: function (form, options) {
        form.addLabel(CPK_ENOVA.t('dc.label.methodparam'));
        form.addField("euvat")
        form.addField("pesel")
        form.addField("kod")
        form.addField("miejscowosc")
        form.addField("nazwa")
        form.addEmptyLine();
        form.addLabel(CPK_ENOVA.t('dc.label.filterby'));
        form.addCombobox({
            id: "filterBy",
            values: getMappings()
        });
        form.addEmptyLine();
        form.addLabel(CPK_ENOVA.t('dc.label.sortingby'));
        form.addCombobox({
            id: "sortBy",
            values: getMappings()
        });
        form.addCombobox({
            id: "sortDirection",
            values: [
                {id: "ASC", display: CPK_ENOVA.t('dc.ASC')},
                {id: "DESC", display: CPK_ENOVA.t('dc.DESC')}
            ]
        });
        form.addField("configId");

        function getMappings() {
            return [
                {id: "id", display: "ID"},
                {id: "kod", display: "Kod"},
                {id: "blokada_sprzedazy", display: "Blokada sprzedaży"},
                {id: "krs", display: "KRS"},
                {id: "euvat", display: "EuVAT"},
                {id: "nazwa", display: "Nazwa"},
                {id: "odzial", display: "Odział"},
                {id: "pesel", display: "PESEL"},
                {id: "rachunek_domyslny", display: "Rachunek domyślny"},
                {id: "regon", display: "REGON"},
                {id: "status_podmiotu", display: "Status podmiotu"},
                {id: "uwagi", display: "Uwagi"},
                {id: "forma_platnosci_blokada", display: "FormaPłatności_Blokada"},
                {id: "forma_platnosci_nazwa", display: "FormaPłatności_Nazwa"},
                {id: "forma_platnosci_termin_dni", display: "FormaPłatnościTermin_dni"},
                {id: "adres_faks", display: "Adres_Faks"},
                {id: "adres_gmina", display: "Adres_Gmina"},
                {id: "adres_kod_kraju", display: "Adres_Kod_kraju"},
                {id: "adres_kod_pocztowy", display: "Adres_Kod_pocztowy"},
                {id: "adres_miejscowosc", display: "Adres_Miejscowość"},
                {id: "adres_nr_domu", display: "Adres_Nr_domu"},
                {id: "adres_nr_lokalu", display: "Adres_Nr_lokalu"},
                {id: "adres_poczta", display: "Adres_Poczta"},
                {id: "adres_ulica", display: "Adres_Ulica"},
                {id: "adres_wojewodztwo", display: "Adres_Wojewodztwo"},
                {id: "adres_korespondecyjny_faks", display: "AdresKorespodencyjny_Faks"},
                {id: "adres_korespondecyjny_gmina", display: "AdresKorespodencyjny_Gmina"},
                {id: "adres_korespondecyjny_kod_kraju", display: "AdresKorespodencyjny_Kod_kraju"},
                {id: "adres_korespondecyjny_kod_pocztowy", display: "AdresKorespodencyjny_Kod_pocztowy"},
                {id: "adres_korespondecyjny_miejscowosc", display: "AdresKorespodencyjnyMiejscowość"},
                {id: "adres_korespondecyjny_nr_domu", display: "AdresKorespodencyjny_Nr_domu"},
                {id: "adres_korespondecyjny_nr_lokalu", display: "AdresKorespodencyjny_Nr_lokalu"},
                {id: "adres_korespondecyjny_poczta", display: "AdresKorespodencyjny_Poczta"},
                {id: "adres_korespondecyjny_ulica", display: "AdresKorespodencyjny_Ulica"},
                {id: "adres_korespondecyjny_wojewodztwo", display: "AdresKorespodencyjny_Wojewodztwo"}
            ];
        }
    }
});