/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.pcm.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.cpk.pcm.dtos.ConnectionConfiguration;
import com.suncode.plugin.cpk.pcm.services.IConfigurationService;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationService
implements IConfigurationService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigurationFileService configurationFileService;
    private final Plugin plugin;

    @Autowired
    public ConfigurationService(ConfigurationFileService configurationFileService, Plugin plugin) {
        this.configurationFileService = configurationFileService;
        this.plugin = plugin;
    }

    @Override
    public ConnectionConfiguration readConfigurationFile(String configurationID) throws IOException {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configurationID);){
            String configuration = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            ConnectionConfiguration connectionConfiguration = (ConnectionConfiguration)this.mapper.readValue(configuration, ConnectionConfiguration.class);
            return connectionConfiguration;
        }
    }
}

