/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.webservice.engine;

import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class RestTemplateResponseErrorHandler
implements ResponseErrorHandler {
    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return httpResponse.getStatusCode().isError();
    }

    public void handleError(ClientHttpResponse httpResponse) throws IOException {
        HttpStatusCode statusCode = httpResponse.getStatusCode();
        if (statusCode instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)statusCode;
            HttpStatus.Series series = httpStatus.series();
            if (series == HttpStatus.Series.SERVER_ERROR) {
                throw new ServerErrorException(httpResponse.getStatusText());
            }
            if (series == HttpStatus.Series.CLIENT_ERROR) {
                throw new ClientErrorException(httpResponse.getStatusText());
            }
        } else {
            int rawStatus = statusCode.value();
            if (rawStatus >= 500 && rawStatus < 600) {
                throw new ServerErrorException(httpResponse.getStatusText());
            }
            if (rawStatus >= 400 && rawStatus < 500) {
                throw new ClientErrorException(httpResponse.getStatusText());
            }
        }
    }

    private static class ServerErrorException
    extends RuntimeException {
        public ServerErrorException(String statusText) {
            super(statusText);
        }
    }

    private static class ClientErrorException
    extends RuntimeException {
        public ClientErrorException(String statusText) {
            super(statusText);
        }
    }
}

