/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.webservice.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.cpk.enova.webservice.engine.EnovaRequestBody;
import com.suncode.plugin.cpk.enova.webservice.engine.EnovaRequestParam;
import com.suncode.plugin.cpk.enova.webservice.engine.EnovaResponse;
import com.suncode.plugin.cpk.enova.webservice.engine.EnovaResponseException;
import com.suncode.plugin.cpk.enova.webservice.engine.EnovaResultInstance;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class EnovaRequestInvoker {
    private static final Logger log = LoggerFactory.getLogger(EnovaRequestInvoker.class);
    private static final Gson GSON_PRETTY = new GsonBuilder().create();
    private String url;
    private String username;
    private String password;
    private String databaseHandle;

    public EnovaRequestInvoker(String url, String username, String password, String databaseHandle) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.databaseHandle = databaseHandle;
    }

    public <T extends EnovaResultInstance> T send(Class<T> type, String methodName, String serviceName, EnovaRequestParam enovaRequestParam) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String body = GSON_PRETTY.toJson((Object)new EnovaRequestBody(this.username, this.password, this.databaseHandle, serviceName, methodName, new EnovaRequestBody.MethodArgs(enovaRequestParam)));
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity jsonResponse = restTemplate.postForEntity(this.url, (Object)entity, String.class, new Object[0]);
        log.info("Method name: " + methodName);
        log.info("Service name: " + serviceName);
        log.info("Request: " + GSON_PRETTY.toJson((JsonElement)new JsonParser().parse(body).getAsJsonObject()));
        log.info("Response: " + (String)jsonResponse.getBody());
        EnovaResponse enovaResponse = (EnovaResponse)GSON_PRETTY.fromJson((String)jsonResponse.getBody(), TypeToken.getParameterized(EnovaResponse.class, (Type[])new Type[]{type}).getType());
        if (enovaResponse.isIsException()) {
            log.error(enovaResponse.getExceptionMessage());
            throw new EnovaResponseException(enovaResponse.getExceptionMessage());
        }
        return enovaResponse.getResultInstance();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseHandle() {
        return this.databaseHandle;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseHandle(String databaseHandle) {
        this.databaseHandle = databaseHandle;
    }
}

