/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.tools;

import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.workflow.variable.Variable;
import java.math.BigDecimal;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functions {
    private static final Logger log = LoggerFactory.getLogger(Functions.class);

    private Functions() {
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDateTime dateTime) throws DatatypeConfigurationException {
        if (dateTime == null) {
            return null;
        }
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(dateTime.toDateTime().toGregorianCalendar());
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDate date) throws DatatypeConfigurationException {
        if (date == null) {
            return null;
        }
        LocalTime time = new LocalTime(0L);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(date.toDateTime(time).toGregorianCalendar());
    }

    public static int maxLength(int currentLength, Object[] obj) {
        if (obj != null && obj.length > currentLength) {
            return obj.length;
        }
        return currentLength;
    }

    public static <T> T getValueFromArray(int i, T[] array) {
        if (array != null && i >= 0 && i < array.length) {
            return array[i];
        }
        return null;
    }

    public static void setVariableValue(Parameters parameteres, String parametrId, Object value) {
        if (value != null && parameteres.exists(parametrId)) {
            Variable variable = (Variable)parameteres.get(parametrId, Variable.class);
            if (variable != null) {
                log.info("Save:\t" + value.toString() + " " + value.getClass().getSimpleName() + "\t to:\t" + parametrId);
                variable.setValue(value);
            } else {
                log.info(" Dont Save NULL:\t\t to:\t" + parametrId);
            }
        }
    }

    public static BigDecimal toBigDecimal(Double number) {
        return number == null ? null : new BigDecimal(number.toString());
    }

    public static java.sql.Date convertDate(XMLGregorianCalendar xmlDate) {
        Date time = xmlDate.toGregorianCalendar().getTime();
        return new java.sql.Date(time.getTime());
    }
}

