/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.task;

import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.payments.dto.GetPlatnosciParams;
import com.suncode.plugin.cpk.enova.webservice.payments.dto.GetResultPlatnosc;
import com.suncode.plugin.cpk.enova.webservice.payments.dto.PlatnoscExp;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class AcceptActivityGetPlatnosciTask {
    private static final Logger log = LoggerFactory.getLogger(AcceptActivityGetPlatnosciTask.class);
    @Autowired
    private EnovaService enovaService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("enova.acceptance.platnosci.task")).name("AcceptActivityGetPlatnosciTask")).description("Akceptacja zadania po odpowiedzi  z metody GetPlatnosci")).parameter().id("processDefId").name("ProcessDefId").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("activityDefId").type((Type)Types.STRING).create()).parameter().id("action").name("Akcja akceptacyjna formularz").optional().type((Type)Types.STRING).create()).parameter().id("variableID").name("Identyfikator zmiennej ID dokumentu kosztowego").type((Type)Types.STRING).create()).parameter().id("variableDataPlatnosci").name("Identyfikator zmiennej Data P\u0142atnosci").type((Type)Types.STRING).optional().create()).parameter().id("variableKodTransakcji").name("Identyfikator zmiennej Kod transakcji").type((Type)Types.STRING).create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create();
    }

    public String execute(@Param String processDefId, @Param String activityDefId, @Param String action, @Param String variableID, @Param String variableDataPlatnosci, @Param String variableKodTransakcji, @Param String configId, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, org.apache.log4j.Logger taskLog) {
        taskLog.debug((Object)("Run: " + scheduledTaskInfo.getName()));
        taskLog.debug((Object)("Param procesDefId: " + processDefId));
        taskLog.debug((Object)("Param activityDefId " + activityDefId));
        taskLog.debug((Object)("Param action " + action));
        taskLog.debug((Object)("Param ID varId" + variableID));
        taskLog.debug((Object)("Param Data P\u0142atno\u015bci varId" + variableDataPlatnosci));
        taskLog.debug((Object)("Param Kod transakcji varId" + variableKodTransakcji));
        List<Activity> activities = this.getOpenActivities(processDefId, activityDefId);
        taskLog.debug((Object)("Found : " + activities.size() + " open activities"));
        int acceptanceCount = 0;
        int errorCount = 0;
        for (Activity activity : activities) {
            Map context = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            String valueIDK = context.getOrDefault(variableID, "");
            taskLog.debug((Object)("ID value: " + valueIDK.toString()));
            if (!StringUtils.isNotBlank((CharSequence)valueIDK.toString())) continue;
            try {
                GetPlatnosciParams param = new GetPlatnosciParams();
                param.setID(Integer.valueOf(valueIDK.toString().trim()));
                this.enovaService.setConfiguration(configId);
                GetResultPlatnosc result = this.enovaService.getPlatnosci(param);
                this.logResult(taskLog, result);
                if (result.getSuccess().booleanValue() && result.getData().size() == 1) {
                    for (PlatnoscExp platnoscExp : result.getData()) {
                        taskLog.debug((Object)platnoscExp.toString());
                    }
                    String dataPlatnosci = result.getData().get(0).getDataPlatnosci();
                    String kodTransakcji = result.getData().get(0).getKodTransakcji();
                    if (StringUtils.isNotBlank((CharSequence)variableKodTransakcji)) {
                        context.put(variableKodTransakcji, kodTransakcji);
                    }
                    if (StringUtils.isNotBlank((CharSequence)variableDataPlatnosci)) {
                        LocalDate localDate = DateTime.parse((String)dataPlatnosci).toLocalDate();
                        context.put(variableDataPlatnosci, localDate.toString("yyyy-MM-dd"));
                    }
                    taskLog.debug((Object)("Try acceptance " + activity.getActivityId()));
                    this.acceptActivity(action, activity, context);
                    ++acceptanceCount;
                    continue;
                }
                if (!result.getSuccess().booleanValue()) {
                    taskLog.debug((Object)"Error");
                    ++errorCount;
                    continue;
                }
                if (result.getSuccess().booleanValue() && result.getData().size() > 1) {
                    taskLog.debug((Object)"Skip. To many results.");
                    continue;
                }
                taskLog.debug((Object)"Skip. Empty response.");
            }
            catch (Exception e) {
                log.error("Error accepting activity with ID: " + activity.getActivityId(), (Throwable)e);
                taskLog.debug((Object)("Error: " + e.getMessage()));
                ++errorCount;
            }
        }
        return this.summarize(acceptanceCount, errorCount, activities.size());
    }

    private void logResult(org.apache.log4j.Logger taskLog, GetResultPlatnosc result) {
        taskLog.debug((Object)("WebService EnovaResponse:\n" + result.getLog()));
        for (PlatnoscExp platnosci : result.getData()) {
            taskLog.debug((Object)platnosci.toString());
        }
    }

    private void acceptActivity(String action, Activity activity, Map<String, Object> context) {
        AcceptationDefinition acceptation = new AcceptationDefinition(activity.getProcessId(), activity.getActivityId(), this.getUserName(), StringUtils.isBlank((CharSequence)action) ? null : action);
        acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
        acceptation.setContextMap(context);
        this.activityService.acceptActivity(acceptation);
    }

    private String getUserName() {
        String userName = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.BUFOR_USERNAME);
        if (StringUtils.isBlank((CharSequence)userName)) {
            return "admin";
        }
        return userName;
    }

    private List<Activity> getOpenActivities(String sProcessDefId, String sActivityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(ActivityEntity.class);
        dc = dc.createAlias("process", "process");
        dc = dc.createAlias("process.processDefinition", "processDef");
        dc = dc.createAlias("activityState", "activityStateName");
        dc.setFetchMode("process", FetchMode.JOIN);
        dc.setFetchMode("activityState", FetchMode.JOIN);
        dc.setFetchMode("process.processDefinition", FetchMode.JOIN);
        dc.add((Criterion)Restrictions.eq((String)"processDef.processDefinitionId", (Object)sProcessDefId));
        dc.add((Criterion)Restrictions.eq((String)"activityDefinitionId", (Object)sActivityDefId));
        dc.add((Criterion)Restrictions.like((String)"activityStateName.name", (Object)"open%"));
        return this.activityFinder.findByCriteria(dc);
    }

    private String summarize(int success, int errors, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append("Success\t").append(success).append("/").append(size).append("\t");
        sb.append("Error\t").append(errors).append("/").append(size).append("\t");
        sb.append("Skip\t").append(size - errors - success).append("/").append(size).append("\t");
        return sb.toString();
    }
}

