/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.plugin.cpk.enova.categories.Categories;
import com.suncode.plugin.cpk.enova.datachooser.DCUtils;
import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.paymentmethods.dto.GetResultSposobyZaplaty;
import com.suncode.plugin.cpk.enova.webservice.paymentmethods.dto.GetSposobyZaplatyParams;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
@ComponentsFormScript(value="/scripts/dpwe/dc.paymentmethods.form.js")
public class GetPaymentMethodsDC {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentMethodsDC.class);
    @Autowired
    private EnovaService enovaService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("enova.paymentmethods.dc")).name("dc.enova.paymentmethods.name")).description("dc.enova.paymentmethods.desc")).category(new Category[]{Categories.CPK_ENOVA})).icon((Icon)SilkIconPack.MONEY_DELETE)).parameter().id("pominZablokowane").name("PominZablokowane").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("filterBy").name("dc.filterBy.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.sortBy.name").type((Type)Types.STRING).defaultValue((Object)"id").optional().create()).parameter().id("sortDirection").name("dc.sortDirection.name").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create()).mapping().id("id").name("ID").create().mapping().id("blokada").name("Blokada").create().mapping().id("nazwa").name("Nazwa").create().mapping().id("typ").name("Typ").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param Boolean pominZablokowane, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection, @Param String configId) throws IOException {
        try {
            GetSposobyZaplatyParams param = new GetSposobyZaplatyParams();
            param.setPominZablokowane(pominZablokowane);
            this.enovaService.setConfiguration(configId);
            GetResultSposobyZaplaty response = this.enovaService.getPaymentMethods(param);
            if (response != null) {
                log.info(response.getLog());
                if (response.getSuccess().booleanValue()) {
                    List<Map<String, Object>> data = response.getSposobyZaplaty().stream().filter(Objects::nonNull).map(rates -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", rates.getID());
                        map.put("blokada", rates.getBlokada());
                        map.put("nazwa", rates.getNazwa());
                        map.put("typ", (Object)rates.getTyp());
                        return map;
                    }).collect(Collectors.toList());
                    DCUtils dcUtils = new DCUtils(data);
                    dcUtils.processData(queryData, filterBy, sortBy, sortDirection);
                    result.setData(dcUtils.getData());
                    result.setTotal(dcUtils.getTotal());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }
}

