/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.plugin.cpk.enova.categories.Categories;
import com.suncode.plugin.cpk.enova.datachooser.DCUtils;
import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.dictionaryfilter.dto.FeatureDTO;
import com.suncode.plugin.cpk.enova.webservice.dictionaryfilter.dto.GetResultSlownikElementow;
import com.suncode.plugin.cpk.enova.webservice.dictionaryfilter.dto.GetSlownikElementowParams;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
@ComponentsFormScript(value="/scripts/dpwe/dc.dictionaryfilter.form.js")
public class GetDictionaryWithFilterDC {
    private static final Logger log = LoggerFactory.getLogger(GetDictionaryWithFilterDC.class);
    @Autowired
    private EnovaService enovaService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("enova.dictionaryfilter.dc")).name("dc.enova.dictionaryfilter.name")).description("dc.enova.dictionaryfilter.desc")).category(new Category[]{Categories.CPK_ENOVA})).icon((Icon)SilkIconPack.TEXT_UNDERLINE)).parameter().id("nazwaSlownika").name("NazwaSlownika").type((Type)Types.STRING).create()).parameter().id("pobierzZablokowane").name("PobierzZablokowane").type((Type)Types.BOOLEAN).optional().create()).parameter().id("filtr").name("Filtr").type((Type)Types.STRING).optional().create()).parameter().id("filterBy").name("dc.filterBy.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.sortBy.name").type((Type)Types.STRING).defaultValue((Object)"id").optional().create()).parameter().id("sortDirection").name("dc.sortDirection.name").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create()).mapping().id("id").name("ID").create().mapping().id("blokada").name("Blokada").create().mapping().id("nazwa").name("Nazwa").create().mapping().id("note").name("Note").create().mapping().id("symbol").name("Symbol").create().mapping().id("unijny").name("Unijny").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param String nazwaSlownika, @Param String filtr, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection, @Param Boolean pobierzZablokowane, @Param String configId) throws IOException {
        try {
            GetSlownikElementowParams param = new GetSlownikElementowParams();
            param.setNazwaSlownika(nazwaSlownika);
            param.setPobierzZablokowane(pobierzZablokowane);
            param.setFiltr(filtr);
            this.enovaService.setConfiguration(configId);
            GetResultSlownikElementow response = this.enovaService.getDictionaryWithFilter(param);
            if (response != null) {
                log.info(response.getLog());
                if (response.getSuccess().booleanValue()) {
                    log.info(response.getData().getlog());
                    List<Map<String, Object>> data = response.getData().getElementySlownika().stream().filter(Objects::nonNull).map(rates -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", rates.getID());
                        map.put("blokada", rates.getBlokada());
                        map.put("nazwa", rates.getNazwa());
                        map.put("note", rates.getNote());
                        map.put("symbol", rates.getSymbol());
                        map.put("unijny", rates.getUnijny());
                        List<FeatureDTO> features = rates.getFeatures();
                        if (features != null && !features.isEmpty()) {
                            Map<String, Object> featuresMap = rates.getFeatures().stream().filter(Objects::nonNull).filter(feature -> StringUtils.isNotBlank((CharSequence)feature.getName())).collect(Collectors.toMap(dto -> dto.getName().toLowerCase().replace(" ", "_"), FeatureDTO::getValue));
                            map.putAll(featuresMap);
                        }
                        return map;
                    }).collect(Collectors.toList());
                    DCUtils dcUtils = new DCUtils(data);
                    dcUtils.processData(queryData, filterBy, sortBy, sortDirection);
                    result.setData(dcUtils.getData());
                    result.setTotal(dcUtils.getTotal());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }
}

