/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.plugin.cpk.enova.categories.Categories;
import com.suncode.plugin.cpk.enova.datachooser.DCUtils;
import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.vatdefinitions.dto.GetDefinicjaObowiazkuVATParams;
import com.suncode.plugin.cpk.enova.webservice.vatdefinitions.dto.GetResultDefinicjaObowiazkuVAT;
import com.suncode.plugin.cpk.enova.webservice.vatdefinitions.enums.TypTytu\u0142uObowi\u0105zkuVAT;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
@ComponentsFormScript(value="/scripts/dpwe/dc.vatdefinitions.form.js")
public class GetDefinicjaPowstaniaObowiazkuVatDC {
    private static final Logger log = LoggerFactory.getLogger(GetDefinicjaPowstaniaObowiazkuVatDC.class);
    @Autowired
    private EnovaService enovaService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("enova.vatdefinitions.dc")).name("dc.enova.vatdefinitions.name")).description("dc.enova.vatdefinitions.desc")).category(new Category[]{Categories.CPK_ENOVA})).icon((Icon)SilkIconPack.TEXT_INDENT)).parameter().id("id").name("ID").type((Type)Types.STRING).optional().create()).parameter().id("typObowiazku").name("TypObowiazku").type((Type)Types.STRING).optional().create()).parameter().id("filterBy").name("dc.filterBy.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.sortBy.name").type((Type)Types.STRING).defaultValue((Object)"id").optional().create()).parameter().id("sortDirection").name("dc.sortDirection.name").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create()).mapping().id("id").name("ID").create().mapping().id("kod").name("Kod").create().mapping().id("powstanie_obowiazku").name("Powstanie obowi\u0105zku").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param String id, @Param String typObowiazku, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection, @Param String configId) throws IOException {
        try {
            GetDefinicjaObowiazkuVATParams param = new GetDefinicjaObowiazkuVATParams();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                param.setID(Integer.valueOf(id.trim()));
            }
            if (StringUtils.isNotBlank((CharSequence)typObowiazku)) {
                param.setTypObowiazku(TypTytu\u0142uObowi\u0105zkuVAT.valueOf(typObowiazku));
            }
            this.enovaService.setConfiguration(configId);
            GetResultDefinicjaObowiazkuVAT response = this.enovaService.getDefinicjaPowstaniaObowiazkuVat(param);
            if (response != null) {
                log.info(response.getLog());
                if (response.getData() != null) {
                    List<Map<String, Object>> data = response.getData().stream().filter(Objects::nonNull).map(rates -> {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rates.getID());
                        map.put("kod", rates.getKod());
                        map.put("powstanie_obowiazku", rates.getPowstanieObowiazku());
                        return map;
                    }).collect(Collectors.toList());
                    DCUtils dcUtils = new DCUtils(data);
                    dcUtils.processData(queryData, filterBy, sortBy, sortDirection);
                    result.setData(dcUtils.getData());
                    result.setTotal(dcUtils.getTotal());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }
}

