/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.plugin.cpk.enova.categories.Categories;
import com.suncode.plugin.cpk.enova.datachooser.DCUtils;
import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.AdresDTO;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.FormaPlatnosciDTO;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.GetListaKontrahentowParams;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.GetResultListaKontrahentow;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.KontrahentDTO;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
@ComponentsFormScript(value="/scripts/dpwe/dc.contractors.form.js")
public class GetContractorsDC {
    private static final Logger log = LoggerFactory.getLogger(GetContractorsDC.class);
    @Autowired
    private EnovaService enovaService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("enova.contractors.dc")).name("dc.enova.contractors.name")).description("dc.enova.contractors.desc")).category(new Category[]{Categories.CPK_ENOVA})).icon((Icon)SilkIconPack.GROUP)).parameter().id("euvat").name("EuVAT").type((Type)Types.STRING).optional().create()).parameter().id("pesel").name("PESEL").type((Type)Types.STRING).optional().create()).parameter().id("kod").name("Kod").type((Type)Types.STRING).optional().create()).parameter().id("miejscowosc").name("Miejscowo\u015b\u0107").type((Type)Types.STRING).optional().create()).parameter().id("nazwa").name("Nazwa").type((Type)Types.STRING).optional().create()).parameter().id("filterBy").name("dc.filterBy.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.sortBy.name").type((Type)Types.STRING).defaultValue((Object)"id").optional().create()).parameter().id("sortDirection").name("dc.sortDirection.name").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create()).mapping().id("id").name("ID").create().mapping().id("kod").name("Kod").create().mapping().id("blokada_sprzedazy").name("Blokada sprzeda\u017cy").create().mapping().id("krs").name("KRS").create().mapping().id("euvat").name("EuVAT").create().mapping().id("nazwa").name("Nazwa").create().mapping().id("odzial").name("Odzia\u0142").create().mapping().id("pesel").name("PESEL").create().mapping().id("rachunek_domyslny").name("Rachunek domy\u015blny").create().mapping().id("regon").name("REGON").create().mapping().id("status_podmiotu").name("Status podmiotu").create().mapping().id("uwagi").name("Uwagi").create().mapping().id("forma_platnosci_blokada").name("FormaP\u0142atno\u015bci_Blokada").create().mapping().id("forma_platnosci_nazwa").name("FormaP\u0142atno\u015bci_Nazwa").create().mapping().id("forma_platnosci_termin_dni").name("FormaP\u0142atno\u015bciTermin_dni").create().mapping().id("adres_faks").name("Adres_Faks").create().mapping().id("adres_gmina").name("Adres_Gmina").create().mapping().id("adres_kod_kraju").name("Adres_Kod_kraju").create().mapping().id("adres_kod_pocztowy").name("Adres_Kod_pocztowy").create().mapping().id("adres_miejscowosc").name("Adres_Miejscowo\u015b\u0107").create().mapping().id("adres_nr_domu").name("Adres_Nr_domu").create().mapping().id("adres_nr_lokalu").name("Adres_Nr_lokalu").create().mapping().id("adres_poczta").name("Adres_Poczta").create().mapping().id("adres_ulica").name("Adres_Ulica").create().mapping().id("adres_wojewodztwo").name("Adres_Wojewodztwo").create().mapping().id("adres_korespondecyjny_faks").name("AdresKorespodencyjny_Faks").create().mapping().id("adres_korespondecyjny_gmina").name("AdresKorespodencyjny_Gmina").create().mapping().id("adres_korespondecyjny_kod_kraju").name("AdresKorespodencyjny_Kod_kraju").create().mapping().id("adres_korespondecyjny_kod_pocztowy").name("AdresKorespodencyjny_Kod_pocztowy").create().mapping().id("adres_korespondecyjny_miejscowosc").name("AdresKorespodencyjnyMiejscowo\u015b\u0107").create().mapping().id("adres_korespondecyjny_nr_domu").name("AdresKorespodencyjny_Nr_domu").create().mapping().id("adres_korespondecyjny_nr_lokalu").name("AdresKorespodencyjny_Nr_lokalu").create().mapping().id("adres_korespondecyjny_poczta").name("AdresKorespodencyjny_Poczta").create().mapping().id("adres_korespondecyjny_ulica").name("AdresKorespodencyjny_Ulica").create().mapping().id("adres_korespondecyjny_wojewodztwo").name("AdresKorespodencyjny_Wojewodztwo").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection, @Param String euvat, @Param String kod, @Param String miejscowosc, @Param String nazwa, @Param String pesel, @Param String configId) throws IOException {
        try {
            GetListaKontrahentowParams param = new GetListaKontrahentowParams();
            param.setEuVAT(euvat);
            param.setKod(kod);
            param.setMiejscowosc(miejscowosc);
            param.setNazwa(nazwa);
            param.setPESEL(pesel);
            this.enovaService.setConfiguration(configId);
            GetResultListaKontrahentow response = this.enovaService.getContractors(param);
            if (response != null && response.getSuccess().booleanValue()) {
                List<Map<String, Object>> data = response.getKontrahenci().stream().filter(Objects::nonNull).map(rates -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    this.buildContractosMap((KontrahentDTO)rates, (Map<String, Object>)map);
                    return map;
                }).collect(Collectors.toList());
                DCUtils dcUtils = new DCUtils(data);
                dcUtils.processData(queryData, filterBy, sortBy, sortDirection);
                result.setData(dcUtils.getData());
                result.setTotal(dcUtils.getTotal());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private void buildContractosMap(KontrahentDTO contractor, Map<String, Object> map) {
        map.put("id", contractor.getID());
        map.put("kod", contractor.getKod());
        map.put("blokada_sprzedazy", contractor.getBlokadaSprzedazy());
        map.put("krs", contractor.getKRS());
        map.put("euvat", contractor.getEuVAT());
        map.put("nazwa", contractor.getNazwa());
        map.put("odzial", contractor.getOddzial());
        map.put("pesel", contractor.getPESEL());
        map.put("rachunek_domyslny", contractor.getRachunekDomyslny());
        map.put("regon", contractor.getREGON());
        map.put("status_podmiotu", contractor.getStatusPodmiotu().name());
        map.put("uwagi", contractor.getUwagi());
        AdresDTO adres = contractor.getAdres();
        boolean isNullObj = adres == null;
        map.put("adres_faks", isNullObj ? "" : adres.getFaks());
        map.put("adres_gmina", isNullObj ? "" : adres.getGmina());
        map.put("adres_kod_kraju", isNullObj ? "" : adres.getKodKraju());
        map.put("adres_kod_pocztowy", isNullObj ? "" : adres.getKodPocztowyS());
        map.put("adres_miejscowosc", isNullObj ? "" : adres.getMiejscowosc());
        map.put("adres_nr_domu", isNullObj ? "" : adres.getNrDomu());
        map.put("adres_nr_lokalu", isNullObj ? "" : adres.getNrLokalu());
        map.put("adres_poczta", isNullObj ? "" : adres.getPoczta());
        map.put("adres_ulica", isNullObj ? "" : adres.getUlica());
        map.put("adres_wojewodztwo", isNullObj ? "" : adres.getWojewodztwo());
        AdresDTO adresKorespondencyjny = contractor.getAdresKorespondencyjny();
        isNullObj = adresKorespondencyjny == null;
        map.put("adres_korespondecyjny_faks", isNullObj ? "" : adresKorespondencyjny.getFaks());
        map.put("adres_korespondecyjny_gmina", isNullObj ? "" : adresKorespondencyjny.getGmina());
        map.put("adres_korespondecyjny_kod_kraju", isNullObj ? "" : adresKorespondencyjny.getKodKraju());
        map.put("adres_korespondecyjny_kod_pocztowy", isNullObj ? "" : adresKorespondencyjny.getKodPocztowyS());
        map.put("adres_korespondecyjny_miejscowosc", isNullObj ? "" : adresKorespondencyjny.getMiejscowosc());
        map.put("adres_korespondecyjny_nr_domu", isNullObj ? "" : adresKorespondencyjny.getNrDomu());
        map.put("adres_korespondecyjny_nr_lokalu", isNullObj ? "" : adresKorespondencyjny.getNrLokalu());
        map.put("adres_korespondecyjny_poczta", isNullObj ? "" : adresKorespondencyjny.getPoczta());
        map.put("adres_korespondecyjny_ulica", isNullObj ? "" : adresKorespondencyjny.getUlica());
        map.put("adres_korespondecyjny_wojewodztwo", isNullObj ? "" : adresKorespondencyjny.getWojewodztwo());
        FormaPlatnosciDTO payment = contractor.getFormaPlatnosci();
        isNullObj = payment == null;
        map.put("forma_platnosci_blokada", isNullObj ? "" : payment.getBlokada());
        map.put("forma_platnosci_nazwa", isNullObj ? "" : payment.getNazwa());
        map.put("forma_platnosci_termin_dni", isNullObj ? "" : payment.getTerminDni());
    }
}

