/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.plugin.cpk.enova.categories.Categories;
import com.suncode.plugin.cpk.enova.datachooser.DCUtils;
import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.FormaPlatnosciDTO;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.GetListaKontrahentowParams;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.GetResultListaKontrahentow;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.KontrahentDTO;
import com.suncode.plugin.cpk.enova.webservice.contracotrs.dto.RachunekBankowyDTO;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
@ComponentsFormScript(value="/scripts/dpwe/dc.contractor_bills.form.js")
public class GetContractorBillsDC {
    private static final Logger log = LoggerFactory.getLogger(GetContractorBillsDC.class);
    @Autowired
    private EnovaService enovaService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("enova.contractor_bills.dc")).name("dc.enova.contractor_bills.name")).description("dc.enova.contractor_bills.desc")).category(new Category[]{Categories.CPK_ENOVA})).icon((Icon)SilkIconPack.PAGE_WHITE_EXCEL)).parameter().id("euvat").name("EuVAT").type((Type)Types.STRING).optional().create()).parameter().id("pesel").name("PESEL").type((Type)Types.STRING).optional().create()).parameter().id("kod").name("Kod").type((Type)Types.STRING).optional().create()).parameter().id("miejscowosc").name("Miejscowo\u015b\u0107").type((Type)Types.STRING).optional().create()).parameter().id("nazwa").name("Nazwa").type((Type)Types.STRING).optional().create()).parameter().id("filterBy").name("dc.filterBy.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.sortBy.name").type((Type)Types.STRING).defaultValue((Object)"id").optional().create()).parameter().id("sortDirection").name("dc.sortDirection.name").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create()).mapping().id("rachunek_id").name("Rachunek_ID").create().mapping().id("rachunek_blokada").name("Rachunek_Blokada").create().mapping().id("rachunek_domyslne").name("Rachunek_Domy\u015blne").create().mapping().id("rachunek_kod_banku").name("Rachunek_Kod_banku").create().mapping().id("rachunek_kraj").name("Rachunek_Kraj").create().mapping().id("rachunek_numer").name("Rachunek_Numer").create().mapping().id("rachunek_swift").name("Rachunek_SWIFT").create().mapping().id("id").name("ID").create().mapping().id("kod").name("Kod").create().mapping().id("blokada_sprzedazy").name("Blokada sprzeda\u017cy").create().mapping().id("krs").name("KRS").create().mapping().id("euvat").name("EuVAT").create().mapping().id("nazwa").name("Nazwa").create().mapping().id("odzial").name("Odzia\u0142").create().mapping().id("pesel").name("PESEL").create().mapping().id("regon").name("REGON").create().mapping().id("status_podmiotu").name("Status podmiotu").create().mapping().id("uwagi").name("Uwagi").create().mapping().id("forma_platnosci_blokada").name("FormaP\u0142atno\u015bci_Blokada").create().mapping().id("forma_platnosci_nazwa").name("FormaP\u0142atno\u015bci_Nazwa").create().mapping().id("forma_platnosci_termin_dni").name("FormaP\u0142atno\u015bciTermin_dni").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection, @Param String euvat, @Param String kod, @Param String miejscowosc, @Param String nazwa, @Param String pesel, @Param String configId) throws IOException {
        try {
            GetListaKontrahentowParams param = new GetListaKontrahentowParams();
            param.setEuVAT(euvat);
            param.setKod(kod);
            param.setMiejscowosc(miejscowosc);
            param.setNazwa(nazwa);
            param.setPESEL(pesel);
            this.enovaService.setConfiguration(configId);
            GetResultListaKontrahentow response = this.enovaService.getContractors(param);
            if (response != null) {
                log.info(response.getLog());
                if (response.getSuccess().booleanValue()) {
                    List<Map<String, Object>> data = response.getKontrahenci().stream().filter(Objects::nonNull).flatMap(contractor -> {
                        ArrayList<HashMap<String, Object>> listMaps = new ArrayList<HashMap<String, Object>>();
                        List<RachunekBankowyDTO> bills = contractor.getRachunki();
                        if (bills != null && !bills.isEmpty()) {
                            for (RachunekBankowyDTO bill : bills) {
                                if (bill == null) continue;
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                this.buildContractorsMap((KontrahentDTO)contractor, (Map<String, Object>)map);
                                this.buildBillsMap(bill, map);
                                listMaps.add(map);
                            }
                        }
                        return listMaps.stream();
                    }).collect(Collectors.toList());
                    DCUtils dcUtils = new DCUtils(data);
                    dcUtils.processData(queryData, filterBy, sortBy, sortDirection);
                    result.setData(dcUtils.getData());
                    result.setTotal(dcUtils.getTotal());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private void buildBillsMap(RachunekBankowyDTO bill, Map<String, Object> map) {
        map.put("rachunek_blokada", bill.getBlokada());
        map.put("rachunek_domyslne", bill.getDomyslne());
        map.put("rachunek_id", bill.getID());
        map.put("rachunek_kod_banku", bill.getKodBanku());
        map.put("rachunek_kraj", bill.getKraj());
        map.put("rachunek_numer", bill.getNumer());
        map.put("rachunek_swift", bill.getSWIFT());
    }

    private void buildContractorsMap(KontrahentDTO contractor, Map<String, Object> map) {
        map.put("id", contractor.getID());
        map.put("kod", contractor.getKod());
        map.put("blokada_sprzedazy", contractor.getBlokadaSprzedazy());
        map.put("krs", contractor.getKRS());
        map.put("euvat", contractor.getEuVAT());
        map.put("nazwa", contractor.getNazwa());
        map.put("odzial", contractor.getOddzial());
        map.put("pesel", contractor.getPESEL());
        map.put("regon", contractor.getREGON());
        map.put("status_podmiotu", contractor.getStatusPodmiotu().name());
        map.put("uwagi", contractor.getUwagi());
        FormaPlatnosciDTO payment = contractor.getFormaPlatnosci();
        boolean isNullObj = payment == null;
        map.put("forma_platnosci_blokada", isNullObj ? "" : payment.getBlokada());
        map.put("forma_platnosci_nazwa", isNullObj ? "" : payment.getNazwa());
        map.put("forma_platnosci_termin_dni", isNullObj ? "" : payment.getTerminDni());
    }
}

