/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.plugin.cpk.enova.categories.Categories;
import com.suncode.plugin.cpk.enova.datachooser.DCUtils;
import com.suncode.plugin.cpk.enova.webservice.EnovaService;
import com.suncode.plugin.cpk.enova.webservice.accountingrecords.dto.GetKontaKsiegoweParams;
import com.suncode.plugin.cpk.enova.webservice.accountingrecords.dto.GetResultKontaKsiegowe;
import com.suncode.plugin.cpk.enova.webservice.accountingrecords.enums.Rodzaj2Konta;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
@ComponentsFormScript(value="/scripts/dpwe/dc.accountingrecords.form.js")
public class GetAccountingRecordsDC {
    private static final Logger log = LoggerFactory.getLogger(GetAccountingRecordsDC.class);
    @Autowired
    private EnovaService enovaService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("enova.accountingrecords.dc")).name("dc.enova.accountingrecords.name")).description("dc.enova.accountingrecords.desc")).category(new Category[]{Categories.CPK_ENOVA})).icon((Icon)SilkIconPack.TABLE)).parameter().id("symbolOkresuObrachunkowego").name("SymbolOkresuObrachunkowego").type((Type)Types.STRING).optional().create()).parameter().id("symbolKonta").name("SymbolKonta").type((Type)Types.STRING).optional().create()).parameter().id("nazwa").name("Nazwa").type((Type)Types.STRING).optional().create()).parameter().id("rodzaj2").name("Rodzaj2").type((Type)Types.STRING).optional().create()).parameter().id("filterBy").name("dc.filterBy.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("sortBy").name("dc.sortBy.name").type((Type)Types.STRING).defaultValue((Object)"id").optional().create()).parameter().id("sortDirection").name("dc.sortDirection.name").type((Type)Types.STRING).defaultValue((Object)"ASC").optional().create()).parameter().id("configId").name("enova.param.configId.name").description("enova.param.configId.desc").type((Type)Types.STRING).create()).mapping().id("id").name("ID").create().mapping().id("nazwa").name("Nazwa").create().mapping().id("rodzaj2").name("Rodzaj2").create().mapping().id("symbol").name("Symbol").create().enableCustomMappings();
    }

    public void data(ComponentQueryData queryData, DataChooserResult result, ActivityContextMap contextMap, DataChooserContext dcContext, @Param String symbolOkresuObrachunkowego, @Param String symbolKonta, @Param String nazwa, @Param String rodzaj2, @Param String[] filterBy, @Param String sortBy, @Param String sortDirection, @Param String configId) throws IOException {
        try {
            GetKontaKsiegoweParams param = new GetKontaKsiegoweParams();
            param.setNazwa(nazwa);
            param.setSymbolKonta(symbolKonta);
            param.setSymbolOkresuObrachunkowego(symbolOkresuObrachunkowego);
            if (StringUtils.isNotBlank((CharSequence)rodzaj2)) {
                param.setRodzaj2(Rodzaj2Konta.valueOf(rodzaj2));
            }
            this.enovaService.setConfiguration(configId);
            GetResultKontaKsiegowe response = this.enovaService.getAccountingRecords(param);
            if (response != null) {
                log.info(response.getLog());
                if (response.getSuccess().booleanValue()) {
                    List<Map<String, Object>> data = response.getKontaKsiegowe().stream().filter(Objects::nonNull).map(item -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", item.getID());
                        map.put("nazwa", item.getNazwa());
                        map.put("rodzaj2", (Object)item.getRodzaj2());
                        map.put("symbol", item.getSymbol());
                        return map;
                    }).collect(Collectors.toList());
                    DCUtils dcUtils = new DCUtils(data);
                    dcUtils.processData(queryData, filterBy, sortBy, sortDirection);
                    result.setData(dcUtils.getData());
                    result.setTotal(dcUtils.getTotal());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }
}

