/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.cpk.enova.datachooser;

import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DCUtils {
    private List<Map<String, Object>> data;
    private long total;

    public DCUtils(List<Map<String, Object>> data) {
        this.data = data;
        this.total = data.size();
    }

    public void pagination(Pagination pagination) {
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        if (pagination.getLimit() + pagination.getStart() < this.data.size()) {
            tempList.addAll(this.data.subList(pagination.getStart(), pagination.getLimit() + pagination.getStart()));
        } else {
            tempList.addAll(this.data.subList(pagination.getStart(), this.data.size()));
        }
        this.data.clear();
        this.data.addAll(tempList);
    }

    public void filterData(String query, String[] filterBy) {
        if (!StringUtils.hasText((String)query)) {
            return;
        }
        if (filterBy == null || filterBy.length < 1) {
            return;
        }
        if (filterBy.length == 1 && !StringUtils.hasText((String)filterBy[0])) {
            return;
        }
        ArrayList<Map<String, Object>> filterData = new ArrayList<Map<String, Object>>();
        block0: for (Map<String, Object> row : this.data) {
            for (String keyFiltr : filterBy) {
                String value;
                if (!row.containsKey(keyFiltr) || !(value = String.valueOf(row.get(keyFiltr)).toLowerCase()).contains(query.toLowerCase())) continue;
                filterData.add(row);
                continue block0;
            }
        }
        this.data.clear();
        this.data.addAll(filterData);
        this.total = filterData.size();
    }

    public void sort(List<Map<String, Object>> data, final String sortBy, final String sortDirection) {
        Comparator<Map<String, Object>> mapComparator = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> m1, Map<String, Object> m2) {
                if (!m1.containsKey(sortBy) || !m2.containsKey(sortBy)) {
                    return 0;
                }
                if (m1.get(sortBy) == null || m2.get(sortBy) == null) {
                    return 0;
                }
                int compareInt = 0;
                String m1Value = String.valueOf(m1.get(sortBy));
                String m2Value = String.valueOf(m2.get(sortBy));
                try {
                    Double parseParam1 = Double.valueOf(m1Value);
                    Double parseParam2 = Double.valueOf(m2Value);
                    compareInt = parseParam1.compareTo(parseParam2);
                }
                catch (Exception e) {
                    compareInt = m1Value.compareTo(m2Value);
                }
                if (sortDirection.equalsIgnoreCase("DESC")) {
                    compareInt *= -1;
                }
                return compareInt;
            }
        };
        Collections.sort(data, mapComparator);
    }

    public List<Map<String, Object>> processData(ComponentQueryData queryData, String[] filterBy, String sortBy, String sortDirection) {
        this.filterData(queryData.getQuery(), filterBy);
        this.sort(this.data, sortBy, sortDirection);
        this.pagination(queryData.getPagination());
        return this.data;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public long getTotal() {
        return this.total;
    }
}

