/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.core.lib.upgrader;

import com.suncode.upgrader.change.task.Task;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Objects;

public class AddNodeToHomeDirectory
implements Task {
    private static final String NODE_VERSION = "24.11.1";
    public static final String WINDOWS_HOME_DESTINATION_PATH = "files/node/node.exe";
    public static final String LINUX_HOME_DESTINATION_PATH = "files/node/node";
    private static final String PLUSWORKFLOW_HOME = "plusworkflow.home";

    public void run() throws IOException {
        this.copyFile("node/24.11.1/node.exe", WINDOWS_HOME_DESTINATION_PATH);
        this.copyFile("node/24.11.1/node", LINUX_HOME_DESTINATION_PATH);
        this.markUnixNodeExecutable();
    }

    public void rollback() {
    }

    void copyFile(String fileToCopy, String homeDestinationDir) throws IOException {
        Path destinationPath = Paths.get(System.getProperty(PLUSWORKFLOW_HOME), homeDestinationDir);
        try (InputStream fileInputStream = Objects.requireNonNull(this.getClass().getClassLoader().getResource(fileToCopy)).openStream();){
            Path parentDirectory = destinationPath.getParent();
            if (parentDirectory != null && !Files.exists(parentDirectory, new LinkOption[0])) {
                Files.createDirectories(parentDirectory, new FileAttribute[0]);
            }
            Files.copy(fileInputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void markUnixNodeExecutable() {
        Path unixNodeDestination = Paths.get(System.getProperty(PLUSWORKFLOW_HOME), LINUX_HOME_DESTINATION_PATH);
        try {
            Files.setPosixFilePermissions(unixNodeDestination, EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE}));
        }
        catch (IOException | UnsupportedOperationException e) {
            unixNodeDestination.toFile().setExecutable(true, false);
        }
    }
}

