/**
 * Okno informacyjne dot. tworzenia korekt zamówień
 */
PW.FormValidators.create('orders-correction-question-validator', {

    callback: function(windowData) {
    	this.variableService = ServiceFactory.getVariableService();
    	this.variableSetService = ServiceFactory.getVariableSetService(); 
    	this.variableOrdersToSetID = windowData['VARIABLE_ORDERS_ID_TO_SET'],
    	this.variableProcAndActToSetID = windowData['VARIABLE_PROC_AND_ACT_ID_TO_SET'],
    	this.ordersList = windowData['ORDERS_LIST'];
    	this.ordersToRealizationList = windowData['ORDERS_TO_REALIZATION_LIST'];
    	this.ordersCorrectionQuestion();
    },
    ordersCorrectionQuestion : function()
	{
    	var me = this;
    	var records = Ext.util.JSON.decode(me.ordersList);
    	var toRealizationRecords = Ext.util.JSON.decode(me.ordersToRealizationList);
    	
    	if(records.length > 0)
    	{
    		Ext4.MessageBox.show({
    			title:'Rozliczanie zamówień!',
    			msg: 'Czy zamówienia podpięte do PO będą dalej rozliczane?',
    			buttons: Ext4.MessageBox.YESNO,
    			fn: function(btn, text, config)
    			{
    				if(btn == 'yes')
    				{
    					var grid = me.variableSetService.get('wybrane_zamowienia_korekty');
   	    			 	me.variableSetService.clear(grid);
   	    			 	me.acceptTask();
   		    	 	}
   		    	 	else if(btn == 'no')
   		    	 	{
   		    	 		if(toRealizationRecords.length > 0)
   		    	 		{
   		    	 			var message = '<b>UWAGA!</b> Dla następujących zamówień, nie jest możliwe utworzenie korekty z powodu linii bedących w trakcie realizacji.<br>'
   		    	 			for(var i=0; i<toRealizationRecords.length; i++)
   		    	 			{
   		    	 				var orderId = toRealizationRecords[i]["nr_zamowienia"];
   		    	 				var orderLinesIds = toRealizationRecords[i]["id_linii_zamowienia"];
   		    	 				message += '<b>' + orderId + '</b> [' + orderLinesIds + ']<br>'
   		    	 			}
   		    	 			
   		    	 			Ext4.MessageBox.show({
	   		    	 			title:'Rozliczanie zamówień!',
		   		     			msg: message,
		   		     			buttons: Ext4.MessageBox.OKCANCEL,
		   		     			fn: function(btn, text, config)
		   		     			{
		   		     				if(btn == 'ok')
		   		     				{
		   		   		    	 		if(records.length > 1)
		   		   		    	 		{
		   		   		    	 			me.chooseOrders(records);
		   		   		    	 		}
		   		   		    	 		else
		   		   		    	 		{
		   			   		    			var orderId = records[0]["nr_zamowienia"];
		   			   		    			var procAndActivity = records[0]["process_and_activity_id"];
		   			   		    			var grid = me.variableSetService.get('wybrane_zamowienia_korekty');
		   		   		    			
		   			   		    			var newRecord = new Object();
		   			   		    			newRecord[me.variableOrdersToSetID] = orderId;
		   			   		    			newRecord[me.variableProcAndActToSetID] = procAndActivity;
		   		   		    			 
		   			   		    			me.variableSetService.clear(grid);
		   			   		    			me.variableSetService.addRow(grid, false, newRecord);
		   			   		    			me.variableSetService.save(grid);
		   			   		    			me.acceptTask();
		   		   		    	 		}
		   		     				}
		   		     			},
		   		     			icon: Ext4.Msg.WARNING
   		    	 			});
   		    	 		}
   		    	 		else
   		    	 		{
   	   		    	 		if(records.length > 1)
   	   		    	 		{
   	   		    	 			me.chooseOrders(records);
   	   		    	 		}
   	   		    	 		else
   	   		    	 		{
   		   		    			var orderId = records[0]["nr_zamowienia"];
   		   		    			var procAndActivity = records[0]["process_and_activity_id"];
   		   		    			var grid = me.variableSetService.get('wybrane_zamowienia_korekty');
   	   		    			
   		   		    			var newRecord = new Object();
   		   		    			newRecord[me.variableOrdersToSetID] = orderId;
   		   		    			newRecord[me.variableProcAndActToSetID] = procAndActivity;
   	   		    			 
   		   		    			me.variableSetService.clear(grid);
   		   		    			me.variableSetService.addRow(grid, false, newRecord);
   		   		    			me.variableSetService.save(grid);
   		   		    			me.acceptTask();
   	   		    	 		}
   		    	 		}
   		    	 	}
   		     	},
   		     	icon: Ext4.Msg.WARNING
    		});
    	}
    	else
    	{
    		me.acceptTask();
    	}
	},
    chooseOrders : function(records)
    {
    	var me = this;
    	
    	var storage = Ext.data.Record.create([{
		    name: "lp",
		    type: "integer"
		}, {
		    name: "nr_zamowienia",
		    type: "string"
		}, {
		    name: "przedmiot_zamowienia",
		    type: "string"
		}, {
		    name: "process_and_activity_id",
		    type: "string"
		}]);
    	
		var storeReader = new Ext.data.JsonReader({
		    id: 'json_reader',
		    fields: storage
		});

		var store = new Ext.data.Store({
		    storeId: 'orders_dynamic_list',
		    reader: storeReader,
		    fields: storage
		});
		store.loadData(records);
		store.commitChanges();
		
		var gridCheckboxSelectionModel = new Ext.grid.CheckboxSelectionModel({
			checkOnly : true,
			singleSelect : false,
		});

		var gridOrders = new Ext.grid.GridPanel({
			id : 'grid_panel_orders',
			store : store,
			enableColumnResize : false,
			stripeRows : true,
			columnLines : true,
			colModel : new Ext.grid.ColumnModel({
				defaults : {
					sortable : false,
					menuDisabled : true,
					css : 'vertical-align:middle;'
				},
			    columns: [{
			        id: 'lp',
			        header: 'Lp.',
			        width: 40,
			        hidden: false,
			        dataIndex: 'lp',
			        align: 'center'
			    }, {
			        id: 'nr_zamowienia',
			        header: 'Nr zamówienia',
			        width: 250,
			        hidden: false,
			        dataIndex: 'nr_zamowienia',
			        align: 'center'
			    }, {
			        id: 'przedmiot_zamowienia',
			        header: 'Przedmiot zamówienia',
			        width: 250,
			        hidden: false,
			        dataIndex: 'przedmiot_zamowienia',
			        align: 'center'
			    }, {
			        id: 'process_and_activity_id',
			        header: 'Process And Activity ID',
			        width: 250,
			        hidden: true,
			        dataIndex: 'process_and_activity_id',
			        align: 'center'
			    }, gridCheckboxSelectionModel]
			}),
			viewConfig : {
				forceFit : true
			},
			sm : gridCheckboxSelectionModel,
		    width: 576,
		    height: 200,
			frame : true,
			title: 'Wybierz zamówienia, dla których ma nastąpić utworzenie korekty celem rozliczenia całkowitego.'
		});
		
		var form = new Ext.Panel({
		    id: 'load_dynamic_table_form_panel',
		    renderTo: windowOrders,
		    frame: true,
		    bodyStyle: 'padding: 5px 5px 0 5px;',
		    labelWidth: 590
		});
		form.add(gridOrders);

		var acceptButton = new Ext.Button({
		    id: 'accept_load_dynamic_table_storage_panel',
		    text: 'Zatwierdź',
		    cls: 'x-btn-text-icon',
		    icon: 'style/img/fam/accept.png',
		    handler: function () 
		    {
		    	var records = Ext.getCmp('grid_panel_orders').getSelectionModel().getSelections();
		    	var grid = me.variableSetService.get('wybrane_zamowienia_korekty');
		    	me.variableSetService.clear(grid);
		    	Ext.each(records, function (item){
		    		 var newRecord = new Object();
	    			 newRecord[me.variableOrdersToSetID] = item.data['nr_zamowienia'];
	    			 newRecord[me.variableProcAndActToSetID] = item.data['process_and_activity_id'];
		    		 me.variableSetService.addRow(grid, false, newRecord);
		    	});
		    	me.variableSetService.save(grid);
		        windowOrders.close();
		        me.acceptTask();
		    }
		});
		form.addButton(acceptButton);

		var windowOrders = new Ext.Window({
		    width: 600,
		    modal: true,
		    constrain: true,
		    shadow: false,
		    resizable: false,
		    title: 'Rozliczenie zamówień',
		    items: form
		});

		windowOrders.show();
    },
    acceptTask : function()
    {  	
    	this.confirm();
    }
});