PW.FormActions.create('execute-query-new-window-params', {

	defaultActions : {
        button: function(button) {
             this.showWindow();
        }
    },
    
    showWindow : function(){
        var me = this;
        var windowItems = me.getWindowItems();
        this.dbWindow = new Ext4.Window({
                title   : me.get("windowName"),
                width: 300,
                bodyPadding: 10,
                items: windowItems
        });
        this.dbWindow.show();
    },
    
    getWindowItems : function(){
    	var me = this;
    	var fieldsNames = this.get("fieldsNames");
    	var items = [];
    	for (var i = 0; i < fieldsNames.length; i++){
    		var field = {
				xtype: 'textfield',
		        id: 'execute-query-param' + i,
		        fieldLabel: fieldsNames[i],
		        allowBlank: false
    		};
    		items.push(field);
    	}
    	var buttons = {
                buttons : [
                    {
                        text    : me.get("acceptButtonName"),
                        handler : me.executeQuery,
                        scope : me
                    },
                    {
                        width: 50,
                        text    : me.get("cancelButtonName"),
                        handler : me.closeWindow,
                        width   : 100,
                        scope : me
                    }
                ]
            }
    	items.push(buttons);
    	return items;
    },
    
    executeQuery : function(){
    	var me = this;
    	var params = me.getParams();
    	if (params == null || params == undefined) return;
    	this.dbWindow.close();
        jQuery.ajax({
            url: 'plugin/com.suncode-colas-components/dbcontroller/execute',
            contentType: "application/json",
            data: JSON.stringify(params),
            async: false,
            method: 'POST',
            success: function(response){
            	Ext4.Msg.show({
            	    title:'Potwierdzenie',
            	    msg: me.get("successMsg"),
            	    buttons: Ext4.Msg.OK,
            	    icon: Ext4.Msg.INFO,
            	});
            },
            error : function(jqXHR, textStatus, errorThrown){
            	Ext4.Msg.show({
            	    title:'Niepowodzenie',
            	    msg: me.get("failureMsg"),
            	    buttons: Ext4.Msg.OK,
            	    icon: Ext4.Msg.ERROR,
            	});
            }
        });
    },
    
    getParams : function(){
    	var queryParams = this.getConvertedArray(this.get("queryParams"), this.get("queryParamsTypes"));
    	for (var i = 0; i < this.get("fieldsNames").length; i++){
    		var value = Ext4.getCmp('execute-query-param' + i).getValue();
    		if (value == "" || value == null){
    			Ext4.Msg.show({
            	    title:'Niepowodzenie',
            	    msg: "Uzupełnij wszystkie pola formularza.",
            	    buttons: Ext4.Msg.OK,
            	    icon: Ext4.Msg.ERROR,
            	});
    			return;
    		}
    		queryParams.push(value);
    	}
    	return {
            dbName : this.get("dbName"),
            queryId : this.get("queryId"),
            queryParams : queryParams
        };
    },
    
    getConvertedArray : function(array, types){
        var resultArr = [];
        PW.each(array, function(param, index){
            var convertedParam = param;
            if(types[index] == "integer" || types[index] == "float"){
                convertedParam = Number(param);
            }
            else if(types[index] == "date" || types[index] == "datetime"){
            	convertedParam = new Date(param);
            }
            resultArr.push(convertedParam);
        }, this);
        return resultArr;
    },
    
    closeWindow : function(){
        this.dbWindow.close();
    }
});

