/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Validator
public class ValidateSettlements {
    private static Logger log = LoggerFactory.getLogger(ValidateSettlements.class);
    private String[] poTableColumnIds = new String[]{"id_linii_zamowienia", "wartosc"};
    private String[] ordersTableColumnIds = new String[]{"nr_linii_zamowienia", "wartosc_zamowienia", "pozostala_wartosc_do_ro", "wartosc_zamowienia_do_p"};

    @Define
    public void action(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("validate-settlements-validator")).name("Weryfikacja rozlicze\u0144 zam\u00f3wie\u0144")).description("Walidacja sprawdzajaca czy suma warto\u015bci do rozliczenia dla poszczeg\u00f3lnych zam\u00f3wie\u0144 nie przekracza 10% warto\u015bci ca\u0142kowietej")).icon((Icon)SilkIconPack.SCRIPT_ERROR)).category(new Category[]{Categories.CLIENT})).create();
    }

    public void validate(ValidationContext validationContext, ActivityContextMap activityContextMap, ValidationErrors errors) {
        Map<String, Object> contextMap = this.getContextMap(activityContextMap);
        ArrayList<Map<String, Object>> poOrdersToVerify = new ArrayList<Map<String, Object>>();
        List poTable = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.poTableColumnIds);
        for (int index = 0; index < poTable.size(); ++index) {
            Map row = (Map)poTable.get(index);
            String orderLineId = (String)row.get("id_linii_zamowienia");
            int foundIndex = this.getIndexOfValue(poOrdersToVerify, orderLineId);
            if (foundIndex != -1) {
                Map currentData = (Map)poOrdersToVerify.get(foundIndex);
                Double settlementSum = (Double)currentData.get("value") + Double.valueOf((String)row.get("wartosc"));
                currentData.put("value", settlementSum);
                Set indexes = (Set)currentData.get("indexes");
                indexes.add(index);
                currentData.put("indexes", indexes);
                poOrdersToVerify.set(foundIndex, currentData);
                continue;
            }
            HashMap<String, Object> toPut = new HashMap<String, Object>();
            toPut.put("orderId", orderLineId);
            toPut.put("value", Double.valueOf((String)row.get("wartosc")));
            HashSet<Integer> indexes = new HashSet<Integer>();
            indexes.add(index);
            toPut.put("indexes", indexes);
            poOrdersToVerify.add(toPut);
        }
        log.debug("poOrdersToVerify: " + String.valueOf(poOrdersToVerify));
        List ordersTable = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.ordersTableColumnIds);
        for (int index = 0; index < ordersTable.size(); ++index) {
            Map row = (Map)ordersTable.get(index);
            String orderLineId = (String)row.get("nr_linii_zamowienia");
            Double toSettlement = Double.valueOf((String)row.get("pozostala_wartosc_do_ro"));
            Double valueToBeExceeded = Double.valueOf((String)row.get("wartosc_zamowienia_do_p"));
            Double maxToSettlement = toSettlement + valueToBeExceeded;
            int foundIndex = this.getIndexOfValue(poOrdersToVerify, orderLineId);
            if (foundIndex == -1) continue;
            Map currentData = (Map)poOrdersToVerify.get(foundIndex);
            Set rowIndexes = (Set)currentData.get("indexes");
            Double sumOfPoOrders = (Double)currentData.get("value");
            if (!(sumOfPoOrders > maxToSettlement)) continue;
            errors.add("Suma warto\u015bci zam\u00f3wienia <b>" + orderLineId + "</b> w tabeli <b>Pozycje PO</b> nie mo\u017ce przekraczy\u0107 warto\u015bci r\u00f3wnej <b>" + String.format("%.02f", maxToSettlement).replace(".", ",") + "</b>.");
            errors.add("Przekroczono dozwolon\u0105 warto\u015b\u0107 w tabeli <b>Pozycje PO</b>.", "nr_linii_zamowienia", index);
            for (Integer rowIndex : rowIndexes) {
                errors.add("Dozwolona suma warto\u015bci dla zam\u00f3wienia <b>" + orderLineId + "</b> zosta\u0142a przekroczona.", "wartosc", rowIndex.intValue());
            }
        }
    }

    private int getIndexOfValue(List<Map<String, Object>> ordersDataToChange, String orderLineId) {
        int index = -1;
        for (int i = 0; i < ordersDataToChange.size(); ++i) {
            String currentOrderId = (String)ordersDataToChange.get(i).get("orderId");
            if (!StringUtils.equals((String)orderLineId, (String)currentOrderId)) continue;
            index = i;
            break;
        }
        return index;
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }
}

