/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Validator
public class ValidatePZMaxValue {
    public Logger log = LoggerFactory.getLogger(ValidatePZMaxValue.class);
    private String[] PO_COLUMN_IDS = new String[]{"nr_pz", "wartosc"};
    private String PZ_NO_QUERY = "select pz.nr_pz, pz.data_pz, pz.nr_proj, pz.wartosc_pz, ( CAST(wartosc_pz as float) - (select COALESCE(SUM(CAST(NULLIF(po.wartosc, '') as float)), 0.00) as wartosc_rozliczona from pm_idx_rej_po po where po.nr_pz = pz.nr_pz and po.processId != :processId and status_po != 'Uruchomiono' and status_po != 'Anulowane'and status_po != 'Poprawa') - (select COALESCE(SUM(CAST(NULLIF(kpo.wartosc, '') as float)), 0.00) as wartosc_korekt from pm_idx_korekta_po kpo where kpo.nr_pz = pz.nr_pz and kpo.status_korekty = 'ZATWIERDZONO')  ) as wartosc_nierozliczona from WUSR_VV_WF_PZ_PO pz where nr_pz in (:pzNoList)";

    @Define
    public void action(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("validate-pz-max-value-id")).name("validator.validate-pz-max-value.name")).name("validator.validate-pz-max-value.desc")).icon((Icon)SilkIconPack.TABLE_LIGHTNING)).category(new Category[]{Categories.CLIENT})).create();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(ValidationContext validationContext, ActivityContextMap activityContextMap, ValidationErrors errors, Translator translator) {
        Map<String, Object> contextMap = this.getContextMap(activityContextMap);
        HashMap<String, void> poSumByPZ = new HashMap<String, void>();
        HashSet<String> pzNoToCheck = new HashSet<String>();
        List poTable = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.PO_COLUMN_IDS);
        for (Map row : poTable) {
            void var12_14;
            String pzNo = (String)row.get("nr_pz");
            BigDecimal bigDecimal = new BigDecimal((String)row.get("wartosc")).setScale(2, RoundingMode.HALF_UP);
            if (!StringUtils.isNotBlank((String)pzNo)) continue;
            this.log.debug("poValue: " + String.valueOf(bigDecimal));
            if (poSumByPZ.containsKey(pzNo)) {
                BigDecimal bigDecimal2 = bigDecimal.add((BigDecimal)poSumByPZ.get(pzNo));
            }
            poSumByPZ.put(pzNo, var12_14);
            pzNoToCheck.add(pzNo);
        }
        this.log.debug("poSumByPZ: " + String.valueOf(poSumByPZ));
        Map<String, BigDecimal> pzValuesToSettlment = this.getAllPZValuesToSettlment(pzNoToCheck, activityContextMap.getProcessId());
        this.log.debug("pzValuesToSettlment: " + String.valueOf(pzValuesToSettlment));
        HashSet<CallSite> globalErrors = new HashSet<CallSite>();
        for (int i = 0; i < poTable.size(); ++i) {
            BigDecimal pzValueForSettlment;
            BigDecimal pzValueSum;
            Map map = (Map)poTable.get(i);
            String pzNo = (String)map.get("nr_pz");
            if (!StringUtils.isNotBlank((String)pzNo) || !poSumByPZ.containsKey(pzNo) || (pzValueSum = (BigDecimal)poSumByPZ.get(pzNo)).compareTo(pzValueForSettlment = pzValuesToSettlment.get(pzNo)) <= 0) continue;
            errors.add("Przekroczono dost\u0119pn\u0105 warto\u015b\u0107 PZ o <b> " + String.format("%.02f", pzValueSum.subtract(pzValueForSettlment)) + "</b>. Zmniejsz warto\u015b\u0107 rozliczanego PO.", "nr_pz", i);
            globalErrors.add((CallSite)((Object)("Przekroczono dost\u0119pn\u0105 warto\u015b\u0107 PZ o numerze <b>" + pzNo + "</b>. Maksymalna warto\u015b\u0107 do rozliczenia wynosi <b>" + String.format("%.02f", pzValueForSettlment) + "</b>. Zmniejsz warto\u015b\u0107 w tabeli z pozycjami PO dla tego PZ.")));
        }
        for (String string : globalErrors) {
            errors.add(string);
        }
    }

    private Map<String, BigDecimal> getAllPZValuesToSettlment(Set<String> pzNoToCheck, String currentProcessId) {
        if (pzNoToCheck.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, BigDecimal> pzValuesForSettlment = new HashMap<String, BigDecimal>();
        SQLFinder sqlFinder = FinderFactory.getSQLFinder();
        SQLBuilder getQueryBuilder = new SQLBuilder(this.PZ_NO_QUERY);
        String query = StringUtils.replace((String)this.PZ_NO_QUERY, (String)":processId", (String)("'" + currentProcessId + "'"));
        StringBuffer bf = new StringBuffer("");
        for (String pzNo : pzNoToCheck) {
            if (bf.length() == 0) {
                bf.append("'" + pzNo + "'");
                continue;
            }
            bf.append(",'" + pzNo + "'");
        }
        query = StringUtils.replace((String)query, (String)":pzNoList", (String)bf.toString());
        getQueryBuilder.setQuery(query);
        getQueryBuilder.addScalar("nr_pz", (Type)StandardBasicTypes.STRING);
        getQueryBuilder.addScalar("wartosc_nierozliczona", (Type)StandardBasicTypes.DOUBLE);
        List queryResult = sqlFinder.find(getQueryBuilder);
        this.log.debug("queryResult: " + String.valueOf(queryResult));
        for (Map pzData : queryResult) {
            String pz = (String)pzData.get("nr_pz");
            Double value = (Double)pzData.get("wartosc_nierozliczona");
            BigDecimal pzValue = new BigDecimal(value).setScale(2, RoundingMode.HALF_UP);
            this.log.debug("pz=" + pz + ", pzValue=" + String.valueOf(pzValue));
            pzValuesForSettlment.put(pz, pzValue);
        }
        return pzValuesForSettlment;
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }
}

