/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.suncode.colas.categories.Categories;
import com.suncode.colas.db.models.RequiredPOFilterModel;
import com.suncode.colas.db.services.RequiredPOFilterService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Validator
public class ValidatePORequired {
    public static Logger log = LoggerFactory.getLogger(ValidatePORequired.class);
    @Autowired
    private RequiredPOFilterService requiredPOFilterService;

    @Define
    public void action(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("validate-po-required-validator-id")).name("application.validate-po-required.name")).description("application.validate-po-required.desc")).icon((Icon)SilkIconPack.SCRIPT_CODE)).category(new Category[]{Categories.CLIENT})).parameter().id("companySymbol").name("application.validate-po-required.companySymbol.name").type((Type)Types.STRING).create()).parameter().id("costAccountColumn").name("application.validate-po-required.costAccountColumn.name").type((Type)Types.VARIABLE).create()).parameter().id("projectColumn").name("application.validate-po-required.projectColumn.name").type((Type)Types.VARIABLE).create();
    }

    public void validate(@Param String companySymbol, @Param Variable costAccountColumn, @Param Variable projectColumn, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        Assert.isTrue((costAccountColumn.getType() == Types.STRING_ARRAY ? 1 : 0) != 0, (String)("Wrong type of variable " + costAccountColumn.getId() + ". Only STRING_ARRAY type"));
        String[] costAccounts = (String[])costAccountColumn.getValue();
        Assert.isTrue((projectColumn.getType() == Types.STRING_ARRAY ? 1 : 0) != 0, (String)("Wrong type of variable " + projectColumn.getId() + ". Only STRING_ARRAY type"));
        String[] projects = (String[])projectColumn.getValue();
        Assert.isTrue((costAccounts.length == projects.length ? 1 : 0) != 0, (String)("Variable " + costAccountColumn.getId() + " and " + projectColumn.getId() + " has different length"));
        int size = costAccounts.length;
        boolean foundBlockedCombinaction = false;
        for (int index = 0; index < size; ++index) {
            String costAccount = costAccounts[index];
            String project = projects[index];
            boolean foundCombination = this.checkCombination(companySymbol, costAccount, project);
            if (!foundCombination) continue;
            foundBlockedCombinaction = true;
            errors.add(translator.getMessage("application.validate-po-required.costAccount.error"), costAccountColumn.getId(), index);
            errors.add(translator.getMessage("application.validate-po-required.project.error"), projectColumn.getId(), index);
        }
        if (foundBlockedCombinaction) {
            errors.add(translator.getMessage("application.validate-po-required.global.error"));
        }
    }

    private boolean checkCombination(String companySymbol, String costAccount, String project) {
        List<RequiredPOFilterModel> result = this.requiredPOFilterService.getAllByCompany(companySymbol);
        if (result != null) {
            log.debug("Found records by company: " + String.valueOf(result));
            return this.checkFiltersFit(result, costAccount, project);
        }
        return false;
    }

    private boolean checkFiltersFit(List<RequiredPOFilterModel> result, String costAccount, String project) {
        for (RequiredPOFilterModel filters : result) {
            String costAccountFilter = filters.getFiltrKontaKosztowego();
            String projectFilter = filters.getFiltrProjektu();
            String projectExcludeFilters = filters.getFiltrWykluczen();
            log.debug("Current filter: " + String.valueOf(filters));
            if (this.isExcludedProject(project, projectExcludeFilters)) continue;
            if (StringUtils.equals((CharSequence)costAccountFilter.trim(), (CharSequence)costAccount)) {
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)project)) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.length((CharSequence)projectFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)projectFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectFilter.replace("*", ""))) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    log.debug("Found first fit for <" + costAccount + "> and <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)"*")) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
            }
            if (StringUtils.length((CharSequence)costAccountFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)costAccountFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)costAccount, (CharSequence)costAccountFilter.replace("*", ""))) {
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)project)) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.length((CharSequence)projectFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)projectFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectFilter.replace("*", ""))) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)"*")) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
            }
            if (!StringUtils.equals((CharSequence)costAccountFilter.trim(), (CharSequence)"*")) continue;
            if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)project)) {
                log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                return true;
            }
            if (StringUtils.length((CharSequence)projectFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)projectFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectFilter.replace("*", ""))) {
                log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                return true;
            }
            if (!StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)"*")) continue;
            log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
            return true;
        }
        return false;
    }

    private boolean isExcludedProject(String project, String excludeFilters) {
        String[] projectExcludeFilterArray = StringUtils.split((String)excludeFilters, (String)";");
        for (int i = 0; i < projectExcludeFilterArray.length; ++i) {
            if (StringUtils.equals((CharSequence)projectExcludeFilterArray[i].trim(), (CharSequence)project)) {
                log.debug("Found exclude filters for project <" + project + ">: " + excludeFilters);
                return true;
            }
            if (StringUtils.length((CharSequence)projectExcludeFilterArray[i].trim()) > 1 && StringUtils.endsWith((CharSequence)projectExcludeFilterArray[i].trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectExcludeFilterArray[i].trim().replace("*", ""))) {
                log.debug("Found exclude filters for project <" + project + ">: " + excludeFilters);
                return true;
            }
            if (!StringUtils.equals((CharSequence)projectExcludeFilterArray[i].trim(), (CharSequence)"*")) continue;
            log.debug("Found exclude filters for project <" + project + ">: " + excludeFilters);
            return true;
        }
        return false;
    }
}

