/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.suncode.colas.categories.Categories;
import com.suncode.colas.utils.ClientTools;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;

@Validator
public class ValidatePOOpenPeriod {
    public static Logger log = Logger.getLogger(ValidatePOOpenPeriod.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("po-open-period-validator")).name("Walidacja daty PO")).description("Walidacja daty PO")).category(new Category[]{Categories.CLIENT})).parameter().id("poDate").name("Data PO").description("Data PO").type((Type)Types.STRING).create();
    }

    public void validate(@Param(value="poDate") String dataPo, ValidationErrors errors) {
        log.debug((Object)"*************** ValidatePOOpenPeriod ***************");
        String query = "select otwarty_okres from pm_custom_otwarty_okres_po ";
        SQLFinder sqlFinder = FinderFactory.getSQLFinder();
        SQLBuilder sqlBuilder = new SQLBuilder();
        sqlBuilder.setQuery(query);
        sqlBuilder.addScalar("otwarty_okres", (org.hibernate.type.Type)StandardBasicTypes.STRING);
        List results = sqlFinder.find(sqlBuilder);
        if (results.size() > 0) {
            String sOpenedPeriod = (String)((Map)results.get(0)).get("otwarty_okres");
            Date dOpenedPeriod = ClientTools.convertStringToDate((String)((Map)results.get(0)).get("otwarty_okres"), "yyyy-MM-dd");
            Date dPoDate = ClientTools.convertStringToDate(dataPo, "yyyy-MM-dd");
            if (dPoDate.compareTo(dOpenedPeriod) < 0) {
                log.info((Object)("** Wskazana data jest wczesniejsza od " + String.valueOf(dOpenedPeriod)));
                errors.add("Podano niew\u0142a\u015bciw\u0105 Dat\u0119 PO. Data nie mo\u017ce by\u0107 wcze\u015bniejsza od " + sOpenedPeriod + ".");
            }
        } else {
            errors.add("Nie mo\u017cna sprawdzi\u0107 prawid\u0142owo\u015bci Daty PO. Brak otwartego okresu.");
        }
    }
}

