/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.suncode.colas.categories.Categories;
import com.suncode.colas.db.models.RequiredOrdersFilterModel;
import com.suncode.colas.db.services.RequiredOrdersFilterService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Validator
public class ValidateOrdersRequired {
    public static Logger log = LoggerFactory.getLogger(ValidateOrdersRequired.class);
    @Autowired
    private RequiredOrdersFilterService requiredOrdersFilterService;

    @Define
    public void action(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("validate-orders-required-validator-id")).name("application.validate-orders-required.name")).description("application.validate-orders-required.desc")).icon((Icon)SilkIconPack.SCRIPT_CODE)).category(new Category[]{Categories.CLIENT})).parameter().id("companySymbol").name("application.validate-orders-required.companySymbol.name").type((Type)Types.STRING).create()).parameter().id("costAccountColumn").name("application.validate-orders-required.costAccountColumn.name").type((Type)Types.VARIABLE).create()).parameter().id("projectColumn").name("application.validate-orders-required.projectColumn.name").type((Type)Types.VARIABLE).create()).parameter().id("orderIdColumn").name("application.validate-orders-required.orderIdColumn.name").type((Type)Types.VARIABLE).create()).parameter().id("valueColumnId").name("application.validate-orders-required.valueColumnId.name").type((Type)Types.VARIABLE).create()).parameter().id("negativeValueVerificationOn").name("application.validate-orders-required.negativeValueVerificationOn.name").type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public void validate(@Param String companySymbol, @Param Variable costAccountColumn, @Param Variable projectColumn, @Param Variable orderIdColumn, @Param Variable valueColumnId, @Param Boolean negativeValueVerificationOn, ValidationContext validationContext, ValidationErrors errors, Translator translator) {
        Assert.isTrue((costAccountColumn.getType() == Types.STRING_ARRAY ? 1 : 0) != 0, (String)("Wrong type of variable " + costAccountColumn.getId() + ". Only STRING_ARRAY type"));
        String[] costAccounts = (String[])costAccountColumn.getValue();
        Assert.isTrue((projectColumn.getType() == Types.STRING_ARRAY ? 1 : 0) != 0, (String)("Wrong type of variable " + projectColumn.getId() + ". Only STRING_ARRAY type"));
        String[] projects = (String[])projectColumn.getValue();
        Assert.isTrue((orderIdColumn.getType() == Types.STRING_ARRAY ? 1 : 0) != 0, (String)("Wrong type of variable " + orderIdColumn.getId() + ". Only STRING_ARRAY type"));
        String[] ordersId = (String[])orderIdColumn.getValue();
        Assert.isTrue((valueColumnId.getType() == Types.FLOAT_ARRAY ? 1 : 0) != 0, (String)("Wrong type of variable " + valueColumnId.getId() + ". Only FLOAT_ARRAY type"));
        Double[] values = (Double[])valueColumnId.getValue();
        Assert.isTrue((costAccounts.length == projects.length ? 1 : 0) != 0, (String)("Variable " + costAccountColumn.getId() + " and " + projectColumn.getId() + " has different length"));
        Assert.isTrue((ordersId.length == projects.length ? 1 : 0) != 0, (String)("Variable " + orderIdColumn.getId() + " and " + projectColumn.getId() + " has different length"));
        Assert.isTrue((values.length == projects.length ? 1 : 0) != 0, (String)("Variable " + valueColumnId.getId() + " and " + projectColumn.getId() + " has different length"));
        int size = costAccounts.length;
        for (int index = 0; index < size; ++index) {
            boolean foundCombination;
            String costAccount = costAccounts[index];
            String project = projects[index];
            String orderLineId = ordersId[index];
            Double value = values[index];
            if (!negativeValueVerificationOn.booleanValue() && (negativeValueVerificationOn.booleanValue() || !(value >= 0.0)) || !StringUtils.isBlank((CharSequence)orderLineId) || !(foundCombination = this.checkCombination(companySymbol, costAccount, project))) continue;
            errors.add(translator.getMessage("application.validate-orders-required.costAccount.error"), costAccountColumn.getId(), index);
            errors.add(translator.getMessage("application.validate-orders-required.project.error"), projectColumn.getId(), index);
            errors.add(translator.getMessage("application.validate-orders-required.global.error", new Object[]{project, costAccount}));
        }
    }

    private boolean checkCombination(String companySymbol, String costAccount, String project) {
        List<RequiredOrdersFilterModel> result = this.requiredOrdersFilterService.getAllByCompany(companySymbol);
        if (result != null) {
            log.debug("Found records by company: " + String.valueOf(result));
            return this.checkFiltersFit(result, costAccount, project);
        }
        return false;
    }

    private boolean checkFiltersFit(List<RequiredOrdersFilterModel> result, String costAccount, String project) {
        for (RequiredOrdersFilterModel filters : result) {
            String costAccountFilter = filters.getFiltrKontaKosztowego();
            String projectFilter = filters.getFiltrProjektu();
            String projectExcludeFilters = filters.getFiltrWykluczen();
            log.debug("Current filter: " + String.valueOf(filters));
            if (this.isExcludedProject(project, projectExcludeFilters)) continue;
            if (StringUtils.equals((CharSequence)costAccountFilter.trim(), (CharSequence)costAccount)) {
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)project)) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.length((CharSequence)projectFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)projectFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectFilter.replace("*", ""))) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    log.debug("Found first fit for <" + costAccount + "> and <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)"*")) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
            }
            if (StringUtils.length((CharSequence)costAccountFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)costAccountFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)costAccount, (CharSequence)costAccountFilter.replace("*", ""))) {
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)project)) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.length((CharSequence)projectFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)projectFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectFilter.replace("*", ""))) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
                if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)"*")) {
                    log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                    return true;
                }
            }
            if (!StringUtils.equals((CharSequence)costAccountFilter.trim(), (CharSequence)"*")) continue;
            if (StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)project)) {
                log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                return true;
            }
            if (StringUtils.length((CharSequence)projectFilter.trim()) > 1 && StringUtils.endsWith((CharSequence)projectFilter.trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectFilter.replace("*", ""))) {
                log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
                return true;
            }
            if (!StringUtils.equals((CharSequence)projectFilter.trim(), (CharSequence)"*")) continue;
            log.debug("Found first fit for costAccount <" + costAccount + "> and project <" + project + ">: " + String.valueOf(filters));
            return true;
        }
        return false;
    }

    private boolean isExcludedProject(String project, String excludeFilters) {
        String[] projectExcludeFilterArray = StringUtils.split((String)excludeFilters, (String)";");
        for (int i = 0; i < projectExcludeFilterArray.length; ++i) {
            if (StringUtils.equals((CharSequence)projectExcludeFilterArray[i].trim(), (CharSequence)project)) {
                log.debug("Found exclude filters for project <" + project + ">: " + excludeFilters);
                return true;
            }
            if (StringUtils.length((CharSequence)projectExcludeFilterArray[i].trim()) > 1 && StringUtils.endsWith((CharSequence)projectExcludeFilterArray[i].trim(), (CharSequence)"*") && StringUtils.startsWith((CharSequence)project, (CharSequence)projectExcludeFilterArray[i].trim().replace("*", ""))) {
                log.debug("Found exclude filters for project <" + project + ">: " + excludeFilters);
                return true;
            }
            if (!StringUtils.equals((CharSequence)projectExcludeFilterArray[i].trim(), (CharSequence)"*")) continue;
            log.debug("Found exclude filters for project <" + project + ">: " + excludeFilters);
            return true;
        }
        return false;
    }
}

