/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

@Validator
public class ValidateElementIsRequired {
    public static Logger log = Logger.getLogger(ValidateElementIsRequired.class);

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("element-requirement-validator")).name("Walidacja wymagalno\u015bci elementu dla konta kosztowego")).description("Walidacja wymagalno\u015bci elementu dla konta kosztowego")).category(new Category[]{Categories.CLIENT})).parameter().id("kontoKosztowe").name("Konto kosztowe").description("Konto kosztowe").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).create()).parameter().id("grupaMaterialowa").name("Grupa materia\u0142owa").description("Grupa materia\u0142owa").type((com.suncode.pwfl.core.type.Type)Types.STRING_ARRAY).create();
    }

    public void validate(@Param(value="kontoKosztowe") String[] kontoKosztowe, @Param(value="grupaMaterialowa") String[] grupaMaterialowa, ValidationErrors errors) {
        log.debug((Object)"*************** ValidatorDefinitionBuilder ***************");
        if (kontoKosztowe.length == grupaMaterialowa.length) {
            String queryName = "select element2_wymagalnosc_el_6 as wymagalnosc from pm_custom_elementy_konfiguracja";
            SQLFinder sqlFinder = FinderFactory.getSQLFinder();
            block2: for (int i = 0; i < grupaMaterialowa.length; ++i) {
                if (!StringUtils.isBlank((CharSequence)grupaMaterialowa[i])) continue;
                SQLBuilder sqlBuilder = new SQLBuilder();
                sqlBuilder.setQuery(queryName);
                sqlBuilder.addScalar("wymagalnosc", (Type)StandardBasicTypes.STRING);
                sqlBuilder.addFilter((SQLFilter)new SimpleSQLFilter("element6_kod", (Object)"", FilterOperator.NOTEQ));
                sqlBuilder.addFilter((SQLFilter)new SimpleSQLFilter("element6_opis_krotki", (Object)"", FilterOperator.NOTEQ));
                sqlBuilder.addFilter((SQLFilter)new SimpleSQLFilter("element2_kod", (Object)kontoKosztowe[i]));
                try {
                    List results = sqlFinder.find(sqlBuilder);
                    if (results.size() > 0) {
                        for (Map oneResult : results) {
                            String elementIsReuired = (String)oneResult.get("wymagalnosc");
                            if (elementIsReuired.toUpperCase().compareTo("TAK") != 0) continue;
                            log.debug((Object)("Pole Grupa materia\u0142owa jest wymagana dla konta kosztowego: " + kontoKosztowe[i]));
                            errors.add("Prosz\u0119 uzupe\u0142ni\u0107 pole 'Grupa materia\u0142owa' dla konta kosztowego:" + kontoKosztowe[i] + "(linia " + (i + 1) + ".).");
                            continue block2;
                        }
                        continue;
                    }
                    log.warn((Object)("Nie mo\u017cna sprawdzi\u0107 wymagalno\u015bci pola 'Grupa materia\u0142owa' dla konta kosztowego: " + kontoKosztowe[i] + ". Brak konfiguracji dla konta kosztowego."));
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Wyst\u0105pi\u0142 b\u0142\u0105d podczas sprawdzania elemtnu: " + e.getMessage()), (Throwable)e);
                }
            }
        } else {
            errors.add("Wyst\u0105pi\u0142 b\u0142\u0105d podczas walidacji wymagalno\u015bci pol Grupa materia\u0142owa");
        }
    }
}

