/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.validators;

import com.google.gson.Gson;
import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.variable.Variable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ValidatorsScript(value="scripts/validators-callbacks/orders-correction-question.js")
public class OrdersCorrectionQuestion {
    public static Logger log = LoggerFactory.getLogger(OrdersCorrectionQuestion.class);
    @Autowired
    private ActivityService activityService;
    String[] orderProcColIds = new String[]{"id_linii", "wartosc_do_rozliczenia", "status_linii"};

    @Define
    public void action(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("orders-correction-question-validator")).name("Okno z wyborem")).icon((Icon)SilkIconPack.DATABASE_ERROR)).category(new Category[]{Categories.CLIENT})).parameter().id("variableOrdersColumnToSet").name("Lista wybranych zam\u00f3wie\u0144 do utworzenia korekty").type((Type)Types.VARIABLE).create()).parameter().id("variableProcAndActColumnToSet").name("Lista wybranych identyfikator\u00f3w proces\u00f3w i zada\u0144 do utworzenia korekty").type((Type)Types.VARIABLE).create()).parameter().id("columnWithOrders").name("Kolumna z Nr linii zam\u00f3wie\u0144").type((Type)Types.VARIABLE).create()).parameter().id("toSettlementValuesColumn").name("Kolumna z Pozosta\u0142\u0105 warto\u015bci\u0105 do rozliczenia").type((Type)Types.VARIABLE).create()).parameter().id("settledValuesColumn").name("Kolumna z Rozliczon\u0105 warto\u015bci\u0105 zam\u00f3wienia").type((Type)Types.VARIABLE).create()).parameter().id("processAndActivity").name("Kolumna z id procesu i id zadania").type((Type)Types.VARIABLE).create();
    }

    public void validate(@Param Variable variableOrdersColumnToSet, @Param Variable variableProcAndActColumnToSet, @Param Variable columnWithOrders, @Param Variable toSettlementValuesColumn, @Param Variable settledValuesColumn, @Param Variable processAndActivity, ValidationContext validationContext, ActivityContextMap activityContextMap, ValidationErrors errors) {
        String[] colIDs = new String[]{columnWithOrders.getId(), toSettlementValuesColumn.getId(), settledValuesColumn.getId(), processAndActivity.getId()};
        Map<String, Object> contextMap = this.getContextMap(activityContextMap);
        HashSet<String> procAndActToCheck = new HashSet<String>();
        List ordersTable = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])colIDs);
        for (Map row : ordersTable) {
            procAndActToCheck.add((String)row.get(processAndActivity.getId()));
        }
        int lp = 0;
        ArrayList<Map<String, String>> ordersInRealizationList = new ArrayList<Map<String, String>>();
        ArrayList ordersList = new ArrayList();
        for (String procAndAct : procAndActToCheck) {
            String orderLinesActivityId;
            String orderProcessId = StringUtils.split((String)procAndAct, (String)"#")[0];
            Map orderContext = this.activityService.getActivityContext(orderProcessId, orderLinesActivityId = StringUtils.split((String)procAndAct, (String)"#")[1]);
            if (orderContext == null) continue;
            String orderId = (String)orderContext.get("nr_zamowienia");
            String orderDesc = (String)orderContext.get("przedmiot_zamowienia");
            boolean toCreateCorrection = false;
            List orderTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)orderContext, (String[])this.orderProcColIds);
            log.debug("orderTable: " + String.valueOf(orderTable));
            for (Map orderRow : orderTable) {
                String lineId = (String)orderRow.get("id_linii");
                Double toSettlementValue = Double.valueOf((String)orderRow.get("wartosc_do_rozliczenia"));
                String state = (String)orderRow.get("status_linii");
                log.debug("lineId: " + lineId + ", toSettlementValue: " + toSettlementValue + ", state: " + state);
                if (StringUtils.equals((String)state, (String)"W realizacji")) {
                    Map<String, CallSite> toRealizationOrder;
                    int foundIndex = this.getIndexOfValue(ordersInRealizationList, orderId);
                    if (foundIndex != -1) {
                        toRealizationOrder = (Map)ordersInRealizationList.get(foundIndex);
                        String currentLineId = (String)toRealizationOrder.get("id_linii_zamowienia");
                        toRealizationOrder.put("id_linii_zamowienia", (CallSite)((Object)(currentLineId + ", " + lineId)));
                        ordersInRealizationList.set(foundIndex, toRealizationOrder);
                        continue;
                    }
                    toRealizationOrder = new HashMap();
                    toRealizationOrder.put("nr_zamowienia", (CallSite)((Object)orderId));
                    toRealizationOrder.put("id_linii_zamowienia", (CallSite)((Object)lineId));
                    ordersInRealizationList.add(toRealizationOrder);
                    continue;
                }
                if (!(toSettlementValue > 0.0)) continue;
                toCreateCorrection = true;
            }
            if (!toCreateCorrection) continue;
            HashMap<String, String> newRow = new HashMap<String, String>();
            newRow.put("lp", String.valueOf(++lp));
            newRow.put("nr_zamowienia", orderId);
            newRow.put("przedmiot_zamowienia", orderDesc);
            newRow.put("process_and_activity_id", procAndAct);
            ordersList.add(newRow);
        }
        log.debug("ordersList:" + String.valueOf(ordersList));
        log.debug("ordersInRealizationList:" + String.valueOf(ordersInRealizationList));
        String jsonOrders = new Gson().toJson(ordersList);
        String jsonToRealizationOrders = new Gson().toJson(ordersInRealizationList);
        HashMap<String, String> windowData = new HashMap<String, String>();
        if (errors.areEmpty()) {
            windowData.put("VARIABLE_ORDERS_ID_TO_SET", variableOrdersColumnToSet.getId());
            windowData.put("VARIABLE_PROC_AND_ACT_ID_TO_SET", variableProcAndActColumnToSet.getId());
            windowData.put("ORDERS_LIST", jsonOrders);
            windowData.put("ORDERS_TO_REALIZATION_LIST", jsonToRealizationOrders);
            errors.invokeCallback(windowData);
        }
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }

    private int getIndexOfValue(List<Map<String, String>> ordersToRealization, String orderLineId) {
        int index = -1;
        for (int i = 0; i < ordersToRealization.size(); ++i) {
            String currentOrderId = ordersToRealization.get(i).get("nr_zamowienia");
            if (!StringUtils.equals((String)orderLineId, (String)currentOrderId)) continue;
            index = i;
            break;
        }
        return index;
    }
}

