/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.utils;

import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class VariablesConverter {
    public static List<Map<String, Object>> convertVariablesToMapList(Variable[] variables, String[] colIds) {
        ArrayList<Map<String, Object>> dbData = new ArrayList<Map<String, Object>>();
        VariablesConverter.compareLengths(variables.length, colIds.length);
        if (!VariablesConverter.doesContainTabularVariables(variables)) {
            VariablesConverter.addOrdinaryVariablesData(dbData, variables, colIds);
        } else {
            VariablesConverter.addTabularVariablesData(dbData, variables, colIds);
        }
        return dbData;
    }

    private static void addOrdinaryVariablesData(List<Map<String, Object>> dbData, Variable[] variables, String[] colIds) {
        HashMap<String, Object> ordinaryVariablesRow = new HashMap<String, Object>();
        for (int i = 0; i < variables.length; ++i) {
            ordinaryVariablesRow.put(colIds[i], variables[i].getValue());
        }
        dbData.add(ordinaryVariablesRow);
    }

    private static void addTabularVariablesData(List<Map<String, Object>> dbData, Variable[] variables, String[] colIds) {
        int dynamicTableLength = VariablesConverter.determineDynamicTableLength(variables);
        VariablesConverter.createEmptyRows(dynamicTableLength, dbData);
        for (int i = 0; i < variables.length; ++i) {
            for (int j = 0; j < dbData.size(); ++j) {
                VariablesConverter.fillRowsWithData(dbData, variables, i, j, colIds);
            }
        }
    }

    private static void fillRowsWithData(List<Map<String, Object>> dbData, Variable[] variables, int horizontalIndex, int verticalIndex, String[] colIds) {
        Map<String, Object> row = dbData.get(verticalIndex);
        if (!variables[horizontalIndex].isArray()) {
            row.put(colIds[horizontalIndex], variables[horizontalIndex].getValue());
        } else {
            Object[] values = (Object[])variables[horizontalIndex].getValue();
            row.put(colIds[horizontalIndex], values[verticalIndex]);
        }
    }

    private static void compareLengths(int variablesLength, int colIdsLength) {
        Assert.isTrue((colIdsLength == variablesLength ? 1 : 0) != 0, (String)"The number of variables is not the same as the number of column ids!");
    }

    private static int determineDynamicTableLength(Variable[] variables) {
        int dynamicTableLength = 0;
        for (Variable variable : variables) {
            Object[] values;
            if (!variable.isArray() || (values = (Object[])variable.getValue()).length <= dynamicTableLength) continue;
            dynamicTableLength = values.length;
        }
        return dynamicTableLength;
    }

    private static boolean doesContainTabularVariables(Variable[] variables) {
        for (Variable variable : variables) {
            if (!variable.isArray()) continue;
            return true;
        }
        return false;
    }

    private static void createEmptyRows(int dynamicTableLength, List<Map<String, Object>> dbData) {
        for (int i = 0; i < dynamicTableLength; ++i) {
            HashMap row = new HashMap();
            dbData.add(row);
        }
    }
}

