/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.utils;

import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ErrorMessageToCommentHandler {
    private CommentService commentService;

    @Autowired
    public ErrorMessageToCommentHandler(CommentService commentService) {
        Assert.notNull((Object)commentService, (String)"commentService is null");
        this.commentService = commentService;
    }

    public void addComment(String processId, String activityId, String msg) {
        String previousActivityId = this.getPreviousActivity();
        Assert.notNull((Object)previousActivityId, (String)"Could not get activityId belonging to previous activity!");
        Comment comment = new Comment();
        comment.setProcessId(processId);
        comment.setActivityId(previousActivityId);
        comment.setComment(msg);
        comment.setUserId("admin");
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        this.commentService.createComment(comment);
    }

    private String getPreviousActivity() {
        String previousActivityId = null;
        if (AcceptanceContext.isActive()) {
            previousActivityId = AcceptanceContext.current().getActivityId();
        }
        return previousActivityId;
    }
}

