/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.utils;

import com.suncode.colas.utils.ClientTools;
import com.suncode.colas.utils.InternalDataBase;
import com.suncode.cuf.math.MathFunctions;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ChangeReservationData {
    public static Logger log = Logger.getLogger(ChangeReservationData.class);

    public static void releaseUnusedZbValues(String sId, Float sValue, Float sAmount, String activityId, String processId) {
        try {
            log.debug((Object)("Aktualizacja wiersza: " + sId + " wartoscia " + sValue));
            if (StringUtils.isBlank((CharSequence)sId)) {
                throw new Exception("Brak numeru wiersza do zwolnienia");
            }
            String sKodKreskowyZb = sId.substring(0, 8);
            Map<String, Object> hmId = ChangeReservationData.getZbProcessAndActivityIdForPo(sKodKreskowyZb);
            if (!hmId.isEmpty()) {
                ProcessService processService = ServiceFactory.getProcessService();
                ActivityService activityService = ServiceFactory.getActivityService();
                Map mContextMapPO = activityService.getActivityContext(processId, activityId);
                Map mContextMap = processService.getProcessContext((String)hmId.get("processid"));
                String sWartoscDoRealizacji = mContextMap.get("wartosc_do_realizacji").toString();
                String sWartosc = mContextMap.get("wartosc").toString();
                String sLineStatus = mContextMap.get("status_linii").toString();
                String sRowIds = mContextMap.get("id_linii_zlecenia").toString();
                String sIlosc = mContextMapPO.get("ilosc_zlecenie").toString();
                String sIloscPoprzednia = "";
                if (mContextMapPO.containsKey("poprzednia_ilosc_zlec")) {
                    sIloscPoprzednia = mContextMapPO.get("poprzednia_ilosc_zlec").toString();
                }
                String sCenaJednostkowa = mContextMapPO.get("cena_jednostkowa_zlecenie").toString();
                String sIdLinii = mContextMapPO.get("id_linii_zlecenia").toString();
                String[] sIds = sRowIds.split(";", -1);
                String[] sRemainingValuesToSettle = sWartoscDoRealizacji.split(";", -1);
                String[] sValuesToSettle = sWartosc.split(";", -1);
                String[] sIloscTab = sIlosc.split(";", -1);
                String[] sIloscPoprzedniaTab = sIloscPoprzednia.split(";", -1);
                String[] sCenaJednostkowaTab = sCenaJednostkowa.split(";", -1);
                String[] sIdLiniiTab = sIdLinii.split(";", -1);
                boolean isUsed = ChangeReservationData.checkIfZbLineUsed(sId, processId);
                double dZbRowValueToSettle = 0.0;
                double dZbRowRemainingValueToSettle = 0.0;
                double dIlosc = Double.parseDouble(sAmount.toString());
                double dIloscPoprzednia = 0.0;
                double dCenaJednostkowa = 0.0;
                double dRowValue = Double.parseDouble(sValue.toString());
                for (int i = 0; i < sIds.length; ++i) {
                    if (sIds[i].compareTo(sId) != 0) continue;
                    dZbRowValueToSettle = Double.valueOf(sValuesToSettle[i]);
                    dZbRowRemainingValueToSettle = Double.valueOf(sRemainingValuesToSettle[i]);
                    i = sIds.length;
                }
                for (int x = 0; x < sIdLiniiTab.length; ++x) {
                    if (sIdLiniiTab[x].compareTo(sId) != 0) continue;
                    dIloscPoprzednia = Double.valueOf(sIloscPoprzedniaTab[x]);
                    dCenaJednostkowa = Double.valueOf(sCenaJednostkowaTab[x]);
                    x = sIdLiniiTab.length;
                }
                log.debug((Object)("Wartosc do realizacji z procesu ZB: " + dZbRowRemainingValueToSettle + ", wartosc calkowita: " + dZbRowValueToSettle));
                log.debug((Object)("Dane z PO: ilosc - " + dIlosc + ", poprzednia ilosc - " + dIloscPoprzednia + ", cena jedn. - " + dCenaJednostkowa));
                if (!isUsed) {
                    dZbRowValueToSettle -= dRowValue;
                } else if (isUsed && (activityId.contains("tworzenie") || activityId.contains("akceptacja_po"))) {
                    dZbRowValueToSettle = dZbRowRemainingValueToSettle - dRowValue;
                } else if (isUsed && (activityId.contains("poprawianie") || activityId.contains("po_zmianach"))) {
                    dZbRowValueToSettle = dZbRowRemainingValueToSettle - (dIlosc - dIloscPoprzednia) * dCenaJednostkowa;
                }
                log.debug((Object)("Nowa wartosc: " + dZbRowValueToSettle));
                if (dZbRowValueToSettle < 0.0) {
                    dZbRowValueToSettle = 0.0;
                }
                if (dZbRowValueToSettle == 0.0) {
                    mContextMap.put("status_linii", ChangeReservationData.getLineStatusVariable(sId, sLineStatus, sRowIds, "Zrealizowano"));
                } else {
                    mContextMap.put("status_linii", ChangeReservationData.getLineStatusVariable(sId, sLineStatus, sRowIds, "Do realizacji"));
                    mContextMap.put("status", "Zatwierdzono");
                }
                String sValueToSettle = String.valueOf(MathFunctions.round((double)dZbRowValueToSettle, (int)2));
                String sIloscNowa = String.valueOf(dIlosc);
                log.debug((Object)("Ustawiam wartosc lini: " + sValueToSettle));
                if (mContextMap.containsKey("poprzednia_ilosc_zlecs")) {
                    mContextMapPO.put("poprzednia_ilosc_zlec", ChangeReservationData.getLineStatusVariable(sId, sIloscPoprzednia, sIdLinii, sIloscNowa));
                }
                mContextMap.put("wartosc_do_realizacji", ChangeReservationData.getLineStatusVariable(sId, sWartoscDoRealizacji, sRowIds, sValueToSettle));
                activityService.setActivityContext(processId, activityId, mContextMapPO);
                processService.setProcessContext(processId, mContextMapPO);
                activityService.setActivityContext((String)hmId.get("processid"), (String)hmId.get("activityid"), mContextMap);
                processService.setProcessContext((String)hmId.get("processid"), mContextMap);
            }
        }
        catch (Exception e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas zapisywanie zmian w procesie Zb.");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Object> getZbProcessAndActivityIdForPo(String sNrZlecenia) {
        Map<String, Object> hmResult = new HashMap<String, Object>();
        String sQuery = "";
        try {
            sQuery = "select id as activityid, processid from activities where processid = (select distinct processid from pm_idx_zlec_bud where kod_kreskowy = '@kod_kreskowy@') AND (state = 1000001 OR state = 1000003) AND activitydefinitionid = 'oczekiwanie_na_po'";
            sQuery = sQuery.replaceAll("@kod_kreskowy@", sNrZlecenia);
            log.debug((Object)sQuery);
            hmResult = InternalDataBase.executeOneResultQuery(sQuery);
            log.debug((Object)"Query executed");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return hmResult;
    }

    public static boolean checkIfZbLineUsed(String sId, String sProcessId) {
        boolean result = false;
        List<Map<String, Object>> queryResult = null;
        try {
            log.debug((Object)"***************** checkIfZbLineUsed() ******************");
            String sQuery = "select distinct processid from pm_idx_rej_po where processid !='@processid@' AND id_linii_zlecenia = '@sId@'";
            sQuery = sQuery.replaceAll("@processid@", sProcessId);
            sQuery = sQuery.replaceAll("@sId@", sId);
            log.debug((Object)sQuery);
            queryResult = InternalDataBase.executeQuery(sQuery);
            if (queryResult != null && queryResult.size() > 0) {
                log.debug((Object)("Query returned: " + queryResult.size()));
                result = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getLineStatusVariable(String sId, String sLineStatus, String sRowIds, String sText) {
        Object sNewStatus = "";
        if (!StringUtils.isBlank((CharSequence)sRowIds)) {
            String[] sRows = sRowIds.split(";");
            String[] sStatus = sLineStatus.split(";");
            for (int i = 0; i < sRows.length; ++i) {
                sNewStatus = sRows[i].compareTo(sId) == 0 ? (String)sNewStatus + sText + ";" : (sStatus.length > i ? (String)sNewStatus + sStatus[i] + ";" : (String)sNewStatus + ";");
            }
            sNewStatus = ClientTools.cutLastChar((String)sNewStatus);
        }
        return sNewStatus;
    }

    public static void releaseRowZb(String sId) {
        try {
            if (StringUtils.isBlank((CharSequence)sId)) {
                throw new Exception("Brak numeru wiersza do zwolnienia");
            }
            Map<String, Object> hmId = ChangeReservationData.getZbProcessAndActivityIdForPoRow(sId);
            if (!hmId.isEmpty()) {
                ProcessService processService = ServiceFactory.getProcessService();
                ActivityService activityService = ServiceFactory.getActivityService();
                Map processContext = processService.getProcessContext((String)hmId.get("processid"));
                Map activityContext = activityService.getActivityContext((String)hmId.get("processid"), (String)hmId.get("activityid"));
                String sLineStatus = (String)processContext.get("status_linii");
                String sRowIds = (String)processContext.get("id_linii_zlecenia");
                processContext.put("status_linii", ChangeReservationData.getLineStatusVariable(sId, sLineStatus, sRowIds, "Do realizacji"));
                processContext.put("status", "Zatwierdzono");
                activityContext.put("status_linii", ChangeReservationData.getLineStatusVariable(sId, sLineStatus, sRowIds, "Do realizacji"));
                activityContext.put("status", "Zatwierdzono");
            }
        }
        catch (Exception e) {
            log.error((Object)"Wyst\u0105pi\u0142 b\u0142\u0105d podczas zapisywanie zmian w procesie Zb.");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Object> getZbProcessAndActivityIdForPoRow(String sId) {
        Map<String, Object> hmResult = new HashMap<String, Object>();
        String sQuery = "";
        try {
            sQuery = "select id as activityid, processid from activities where processid = (select distinct processid from pm_idx_zlec_bud where id_linii_zlecenia = '@id_linii@') AND (state = 1000001 OR state = 1000003) AND activitydefinitionid = 'oczekiwanie_na_po'";
            sQuery = sQuery.replaceAll("@id_linii@", sId);
            log.debug((Object)sQuery);
            hmResult = InternalDataBase.executeOneResultQuery(sQuery);
            log.debug((Object)"Query executed");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return hmResult;
    }
}

