/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.plannedtask;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.colas.categories.Categories;
import com.suncode.colas.db.models.EndAgreementModel;
import com.suncode.colas.db.services.EndAgreementService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class CreatingHRProcesses {
    private Logger log = Logger.getLogger(CreatingHRProcesses.class);
    private final String PROCESS_DEFINITION_ID = "hr_przedluz";
    private final String FINDER_STATE = "1";
    private final String ERROR_STATE = "2";
    private final String OK_STATE = "3";
    @Autowired
    private EndAgreementService endAgreementService;
    @Autowired
    private UserGroupFinder userGroupFinder;
    @Autowired
    private ProcessService processService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("creating-hr-processes-scheduled-task-id")).name("scheduled-task.creating-hr-processes.name")).description("scheduled-task.creating-hr-processes.desc")).category(new Category[]{Categories.CLIENT})).cancelable().parameter().id("destGroupName").name("scheduled-task.creating-hr-processes.destGroupName.name").description("scheduled-task.creating-hr-processes.destGroupName.desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param String destGroupName, CancelationHandler cancelationHandler, Logger logger, ProgressHolder progressHolder) throws Exception {
        progressHolder.setProgress(Double.valueOf(0.0));
        int foundDataCounter = 0;
        logger.info((Object)("Weryfikacja grupy " + destGroupName));
        this.validateGroupName(destGroupName, logger);
        logger.info((Object)"Wyszukiwanie danych tabeli wusr_hr_koniec_umowy_import ze statusem 1");
        List<EndAgreementModel> foundData = this.endAgreementService.findAgreementsByState("1");
        if (foundData != null) {
            for (EndAgreementModel endAgreementRow : foundData) {
                this.createHRProcess(endAgreementRow, destGroupName, cancelationHandler, logger);
                progressHolder.setProgress(Double.valueOf(foundDataCounter++ / foundData.size()));
            }
        } else {
            logger.info((Object)"Nie znaleziono rekord\u00f3w do przetworzenia");
        }
        progressHolder.setProgress(Double.valueOf(1.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHRProcess(EndAgreementModel endAgreementRow, String destGroupName, CancelationHandler cancelationHandler, Logger logger) {
        if (!cancelationHandler.isCanceled().booleanValue()) {
            try {
                ProcessBuilderDefinition definition = this.buildProcesseDefinition(endAgreementRow, destGroupName, logger);
                String newProcessId = this.processService.createProcess(definition);
                this.processService.startProcess(newProcessId);
                Process newProcess = this.processService.getProcess(newProcessId, new String[]{"processDefinition"});
                String newProcessName = newProcess.getName();
                logger.info((Object)("Utworzono proces o nazwie " + newProcessName + ", id procesu " + newProcessId));
                endAgreementRow.setStatus("3");
                endAgreementRow.setErrorMsg("");
            }
            catch (Exception e) {
                endAgreementRow.setStatus("2");
                endAgreementRow.setErrorMsg(e.getMessage());
                this.log.debug((Object)e.getMessage(), (Throwable)e);
                logger.debug((Object)("B\u0142\u0105d tworzenia procesu HR dla rekordu o ID " + endAgreementRow.getId()));
            }
            finally {
                endAgreementRow.setDataOdczytWORK(Timestamp.valueOf(LocalDateTime.now()));
                this.endAgreementService.update(endAgreementRow);
                logger.info((Object)("Zaktualizowano rekord o ID " + endAgreementRow.getId()));
            }
        }
    }

    private ProcessBuilderDefinition buildProcesseDefinition(EndAgreementModel endAgreementRow, String groupName, Logger logger) {
        String username = SystemProperties.getString((String)"SchedulerToolAgent.sharkUsername");
        Map<String, Object> variables = this.prepareVariables(endAgreementRow, groupName);
        logger.info((Object)("Inicjalizacja zmiennych warto\u015bciami:  " + String.valueOf(variables)));
        String invoicePackageId = this.findInvoicePackageId();
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId(invoicePackageId);
        definition.setProcessDefId("hr_przedluz");
        definition.setCreator(username);
        definition.setVariables(variables);
        definition.setAutoStart(false);
        return definition;
    }

    private String findInvoicePackageId() {
        return XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId("hr_przedluz");
    }

    private Map<String, Object> prepareVariables(EndAgreementModel endAgreementRow, String groupName) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("imie_i_nazwisko", endAgreementRow.getImieNazwisko());
        variables.put("stanowisko", endAgreementRow.getStanowisko());
        variables.put("lokalizacja", endAgreementRow.getLokalizacja());
        variables.put("forma_umowy_obecnej", endAgreementRow.getRodzajUmowy());
        variables.put("poczatek_obecnej_umowy", this.convertDate(endAgreementRow.getDataZatrudnienia()));
        variables.put("koniec_obecnej_umowy", this.convertDate(endAgreementRow.getDataKoniecUmowy()));
        variables.put("firma", endAgreementRow.getFirma());
        variables.put("firma_skrot", endAgreementRow.getFirmaSkrot());
        variables.put("przelozony", endAgreementRow.getPrzelozony());
        variables.put("nosnik_kosztu", endAgreementRow.getMpk());
        variables.put("hr_kadry_place_login", this.getUserLoginsByGroupName(groupName));
        return variables;
    }

    private String convertDate(Timestamp dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return formatter.format(dateTime.toLocalDateTime());
    }

    private void validateGroupName(String destGroupName, Logger logger) {
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        dc.add((Criterion)Restrictions.eq((String)"name", (Object)destGroupName));
        List foundGroups = this.userGroupFinder.findByCriteria(dc);
        if (foundGroups.size() != 1) {
            logger.info((Object)("Nie znaleziono grupy o nazwie " + destGroupName));
            throw new IllegalArgumentException("Nie znaleziono grupy o nazwie " + destGroupName);
        }
    }

    private String getUserLoginsByGroupName(String destGroupName) {
        HashSet<String> userLogins = new HashSet<String>();
        UserGroup userGroup = (UserGroup)this.userGroupFinder.findOneByProperty("name", (Object)destGroupName, new String[]{"users"});
        Set foundUsers = userGroup.getUsers();
        for (User user : foundUsers) {
            userLogins.add(user.getUserName());
        }
        return StringUtils.join(userLogins, (String)";");
    }
}

