/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.db;

import com.google.common.collect.ListMultimap;
import com.suncode.colas.db.DBSynchronizingService;
import com.suncode.colas.db.tables.DBQuery;
import com.suncode.colas.db.tables.DBQueryService;
import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.SessionUnit;
import jakarta.persistence.NoResultException;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dbSynchronizingService")
public class DBSynchronizingServiceImpl
implements DBSynchronizingService {
    Logger log = LoggerFactory.getLogger(DBSynchronizingServiceImpl.class);
    @Autowired
    DatabaseExplorer databaseExplorer;
    @Autowired
    private DBQueryService dbQueryService;

    @Override
    public void executeQuery(String dbName, final String queryKey, final Object[] queryParams) {
        Database database = this.databaseExplorer.get(dbName);
        database.withinSession((SessionUnit)new SessionUnit<ListMultimap<String, Object>>(){

            public ListMultimap<String, Object> doWork(DatabaseSession session) throws Exception {
                String query = DBSynchronizingServiceImpl.this.getQueryFromDBQueries(queryKey);
                DBSynchronizingServiceImpl.this.log.debug("Query returned from DB: {}", (Object)query);
                NativeQuery sql = session.hibernateSession().createSQLQuery(query);
                sql.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                for (int i = 0; i < queryParams.length; ++i) {
                    sql.setParameter(i, queryParams[i]);
                }
                sql.executeUpdate();
                return null;
            }
        });
    }

    private String getQueryFromDBQueries(String queryName) throws NoResultException {
        DBQuery dbQuery = this.dbQueryService.getQueryByName(queryName);
        if (dbQuery == null) {
            throw new NoResultException("Nie znaleziono zapytania o podanym queryName");
        }
        return dbQuery.getQuery();
    }
}

