/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.applications;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class UpdateOrderState {
    public static Logger log = Logger.getLogger(UpdateOrderState.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private AssignmentService assignmentService;
    private String[] ordersCorrPosTableColumns = new String[]{"nr_linii_zamowienia", "pozostala_wartosc_do_ro", "wartosc_korygujaca"};
    private String[] ordersPosTableColumns = new String[]{"id_linii", "wartosc_do_rozliczenia", "status_linii", "nr_korekty_zamowienia"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("update-order-state-app")).name("Aktualizacja status\u00f3w zam\u00f3wienia")).description("Zmiana status\u00f3w i warto\u015bci pozosta\u0142ych do rozliczenia dla linii zam\u00f3wienia.")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.TABLE_SAVE)).parameter().id("sourceProcessId").name("Id procesu Rejestracji zam\u00f3wienia").description("Identyfikator procesu, w kt\u00f3rym nastapi aktualizacja danych.").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap activityContextMap, @Param String sourceProcessId) throws Exception {
        log.trace((Object)"***UpdateOrderState - start****");
        Map<String, Object> corrOrderContextMap = this.getContextMap(activityContextMap);
        log.debug((Object)("corrOrderContextMap: " + String.valueOf(corrOrderContextMap)));
        String corrID = (String)corrOrderContextMap.get("nr_korekty_zamowienia");
        log.debug((Object)("corrID: " + corrID));
        log.debug((Object)("sourceProcessId: " + sourceProcessId));
        String sourceActivityId = this.activityFinder.findLastActivity(sourceProcessId).getActivityId();
        log.debug((Object)("sourceActivityId: " + sourceActivityId));
        Map wfpoContext = null;
        Activity waitingForPoActivity = this.getLastOpenActivity(sourceProcessId, "oczekiwanie_na_po");
        if (waitingForPoActivity != null) {
            wfpoContext = this.activityService.getActivityContext(sourceProcessId, waitingForPoActivity.getActivityId());
        }
        Map rzOrdersContextMap = this.activityService.getActivityContext(sourceProcessId, sourceActivityId);
        List rzOrdersTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)rzOrdersContextMap, (String[])this.ordersPosTableColumns);
        log.debug((Object)("rzOrdersTable: " + String.valueOf(rzOrdersTable)));
        List corrOrdersTable = DynamicTableFunctions.convertFromMapToListOfMaps(corrOrderContextMap, (String[])this.ordersCorrPosTableColumns);
        log.debug((Object)("corrOrdersTable: " + String.valueOf(corrOrdersTable)));
        for (Map corrOrderRow : corrOrdersTable) {
            String corrOrderId = (String)corrOrderRow.get("nr_linii_zamowienia");
            Double corrValue = Double.valueOf((String)corrOrderRow.get("wartosc_korygujaca"));
            Double toSettlement = Double.valueOf((String)corrOrderRow.get("pozostala_wartosc_do_ro"));
            Double currentSettlement = toSettlement - Math.abs(corrValue);
            for (Map rzOrderRow : rzOrdersTable) {
                String orderLineIdToChange = (String)rzOrderRow.get("id_linii");
                String rzCorrectId = (String)rzOrderRow.get("nr_korekty_zamowienia");
                if (!StringUtils.equals((String)corrOrderId, (String)orderLineIdToChange)) continue;
                HashMap<String, String> conditions = new HashMap<String, String>();
                conditions.put("id_linii", orderLineIdToChange);
                HashMap<String, Object> toUpdate = new HashMap<String, Object>();
                if (currentSettlement > 0.0) {
                    toUpdate.put("wartosc_do_rozliczenia", currentSettlement.toString());
                    toUpdate.put("status_linii", "Do realizacji");
                } else {
                    toUpdate.put("wartosc_do_rozliczenia", "0.00");
                    toUpdate.put("status_linii", "Zrealizowano");
                }
                if (StringUtils.isBlank((String)rzCorrectId)) {
                    toUpdate.put("nr_korekty_zamowienia", corrID);
                } else if (!StringUtils.contains((String)rzCorrectId, (String)corrID)) {
                    toUpdate.put("nr_korekty_zamowienia", rzCorrectId + "," + corrID);
                }
                rzOrdersContextMap.putAll(DynamicTableFunctions.updateRecordsAllConditions((Map)rzOrdersContextMap, (String[])this.ordersPosTableColumns, conditions, toUpdate));
                if (wfpoContext == null) continue;
                wfpoContext.putAll(DynamicTableFunctions.updateRecordsAllConditions((Map)wfpoContext, (String[])this.ordersPosTableColumns, conditions, toUpdate));
            }
        }
        rzOrdersTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)rzOrdersContextMap, (String[])this.ordersPosTableColumns);
        if (!this.existRowToRealization(rzOrdersTable)) {
            rzOrdersContextMap.put("status_zamowienia", "ZREALIZOWANE");
            Boolean autoCorrection = (Boolean)corrOrderContextMap.get("utworzenie_automatyczne");
            if (!autoCorrection.booleanValue()) {
                this.activityService.setActivityContext(sourceProcessId, sourceActivityId, rzOrdersContextMap);
                this.processService.setProcessContext(sourceProcessId, rzOrdersContextMap);
                if (waitingForPoActivity.isOpen()) {
                    this.acceptActivityAsAdmin(sourceProcessId, waitingForPoActivity.getActivityId(), rzOrdersContextMap);
                } else if (waitingForPoActivity.getState() == ActivityState.TERMINATED) {
                    rzOrdersContextMap.put("Action", "oczekiwanie_na_po");
                    this.acceptActivityAsAdmin(sourceProcessId, waitingForPoActivity.getActivityId(), rzOrdersContextMap);
                }
            }
        } else {
            this.activityService.setActivityContext(sourceProcessId, sourceActivityId, rzOrdersContextMap);
            this.processService.setProcessContext(sourceProcessId, rzOrdersContextMap);
        }
        if (wfpoContext != null) {
            this.activityService.setActivityContext(sourceProcessId, waitingForPoActivity.getActivityId(), wfpoContext);
        }
        log.debug((Object)("rzOrdersTable: " + String.valueOf(rzOrdersTable)));
        log.trace((Object)"***UpdateOrderState - stop****");
    }

    private void acceptActivityAsAdmin(String processId, String activityId, Map<String, Object> contextMap) throws Exception {
        log.info((Object)("Akceptacja zadania " + activityId + " procesu: " + processId));
        try {
            String userName = "admin";
            String userPwd = SystemProperties.getPassword((String)"AdminPassword");
            this.assignmentService.assignActivityToUser(processId, activityId, userName);
            this.activityService.openActivity(userName, userPwd, processId, activityId);
            AcceptationDefinition acceptation = new AcceptationDefinition(processId, activityId, userName, null);
            acceptation.setContextMap(contextMap);
            acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
            this.activityService.acceptActivity(acceptation);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private boolean existRowToRealization(List<Map<String, String>> rzOrdersTable) {
        boolean existRowToRealization = false;
        for (Map<String, String> row : rzOrdersTable) {
            String state = row.get("status_linii");
            if (StringUtils.equals((String)state, (String)"Zrealizowano")) continue;
            existRowToRealization = true;
            break;
        }
        return existRowToRealization;
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }

    private Activity getLastOpenActivity(String processId, String activityDefId) {
        Activity result = null;
        List activities = this.activityFinder.findOpenedActivities(processId);
        for (Activity activity : activities) {
            if (result != null || !activity.getActivityDefinitionId().equals(activityDefId)) continue;
            result = activity;
            break;
        }
        return result;
    }
}

