/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.applications;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class SaveOrdersSettlement {
    public static Logger log = Logger.getLogger(SaveOrdersSettlement.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    private String[] poTableColumnIds = new String[]{"id_linii_zamowienia", "wartosc"};
    private String[] ordersTableColumnIds = new String[]{"nr_linii_zamowienia", "process_and_activity_id", "rozliczona_wartosc_zamo"};
    private String[] ordersPosTableColumns = new String[]{"id_linii", "status_linii", "wartosc_do_rozliczenia"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("colas-save-order-settlement-setter")).name("Aktualizowanie rozlicze\u0144 dla zam\u00f3wie\u0144")).description("Pozwala na zapis rozliczonej warto\u015bci dla poszczeg\u00f3lnych linii zam\u00f3wie\u0144, kt\u00f3rych PO zosta\u0142y zarejestrowane.")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.TABLE_SAVE)).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap activityContextMap) {
        Map<String, Object> contextMap = this.getContextMap(activityContextMap);
        log.debug((Object)("contextMap: " + String.valueOf(contextMap)));
        ArrayList<Map<String, Object>> ordersDataToChange = new ArrayList<Map<String, Object>>();
        List poTable = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.poTableColumnIds);
        for (Object row : poTable) {
            String orderLineId = (String)row.get("id_linii_zamowienia");
            if (!StringUtils.isNotBlank((String)orderLineId)) continue;
            int n = this.getIndexOfValue(ordersDataToChange, orderLineId);
            if (n != -1) {
                Map currentData = (Map)ordersDataToChange.get(n);
                Double settlementSum = (Double)currentData.get("value") + Double.valueOf((String)row.get("wartosc"));
                currentData.put("value", settlementSum);
                ordersDataToChange.set(n, currentData);
                continue;
            }
            HashMap<String, Object> toPut = new HashMap<String, Object>();
            toPut.put("orderId", orderLineId);
            toPut.put("value", Double.valueOf((String)row.get("wartosc")));
            ordersDataToChange.add(toPut);
        }
        log.debug((Object)("ordersDataToChange: " + String.valueOf(ordersDataToChange)));
        List ordersTable = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.ordersTableColumnIds);
        for (Map row : ordersTable) {
            String string = (String)row.get("nr_linii_zamowienia");
            String processAndActivityId = (String)row.get("process_and_activity_id");
            String settledValue = (String)row.get("rozliczona_wartosc_zamo");
            int foundIndex = this.getIndexOfValue(ordersDataToChange, string);
            if (foundIndex == -1) continue;
            Map currentOrderData = (Map)ordersDataToChange.get(foundIndex);
            currentOrderData.put("processAndActivityId", processAndActivityId);
            currentOrderData.put("settledValue", Double.valueOf(settledValue));
            ordersDataToChange.set(foundIndex, currentOrderData);
        }
        log.debug((Object)("ordersDataToChange: " + String.valueOf(ordersDataToChange)));
        HashMap ordersDataToChangeWithTheSameProcessAndActivityID = new HashMap();
        for (Map map : ordersDataToChange) {
            List<Map> tempList;
            String currentProcessAndActivity = (String)map.get("processAndActivityId");
            if (ordersDataToChangeWithTheSameProcessAndActivityID.containsKey(currentProcessAndActivity)) {
                tempList = (List)ordersDataToChangeWithTheSameProcessAndActivityID.get(currentProcessAndActivity);
                tempList.add(map);
                ordersDataToChangeWithTheSameProcessAndActivityID.put(currentProcessAndActivity, tempList);
                continue;
            }
            tempList = new ArrayList();
            tempList.add(map);
            ordersDataToChangeWithTheSameProcessAndActivityID.put(currentProcessAndActivity, tempList);
        }
        log.debug((Object)("ordersDataToChangeWithTheSameProcessAndActivityID: " + String.valueOf(ordersDataToChangeWithTheSameProcessAndActivityID)));
        for (String string : ordersDataToChangeWithTheSameProcessAndActivityID.keySet()) {
            String orderLinesProcessId = StringUtils.split((String)string, (String)"#")[0];
            String orderLinesActivityId = StringUtils.split((String)string, (String)"#")[1];
            List orderLinesDataToChange = (List)ordersDataToChangeWithTheSameProcessAndActivityID.get(string);
            Map processContext = this.processService.getProcessContext(orderLinesProcessId);
            Map activityContext = this.activityService.getActivityContext(orderLinesProcessId, orderLinesActivityId);
            List rzOrdersTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)activityContext, (String[])this.ordersPosTableColumns);
            log.debug((Object)("rzOrdersTable: " + String.valueOf(rzOrdersTable)));
            for (Map row : rzOrdersTable) {
                for (Map orderLineToChange : orderLinesDataToChange) {
                    String orderLineIdToChange = (String)orderLineToChange.get("orderId");
                    HashMap<String, String> conditions = new HashMap<String, String>();
                    conditions.put("id_linii", orderLineIdToChange);
                    HashMap<String, String> toUpdate = new HashMap<String, String>();
                    if (!StringUtils.equals((String)orderLineIdToChange, (String)((String)row.get("id_linii")))) continue;
                    Double settlementValue = (Double)orderLineToChange.get("value");
                    Double currentSettlementValue = Double.valueOf((String)row.get("wartosc_do_rozliczenia"));
                    Double settledValue = (Double)orderLineToChange.get("settledValue");
                    log.debug((Object)("orderLineIdToChange: " + orderLineIdToChange + ", curentSettlementValue: " + currentSettlementValue + ", settlementValue: " + settlementValue + ", settledValue: " + settledValue));
                    Double result = currentSettlementValue + settledValue - settlementValue;
                    if (result > 0.0) {
                        toUpdate.put("wartosc_do_rozliczenia", result.toString());
                        toUpdate.put("status_linii", "Do realizacji");
                    } else {
                        toUpdate.put("wartosc_do_rozliczenia", "0.00");
                        toUpdate.put("status_linii", "Zrealizowano");
                    }
                    activityContext.putAll(DynamicTableFunctions.updateRecordsAllConditions((Map)activityContext, (String[])this.ordersPosTableColumns, conditions, toUpdate));
                    processContext.putAll(DynamicTableFunctions.updateRecordsAllConditions((Map)activityContext, (String[])this.ordersPosTableColumns, conditions, toUpdate));
                    if (settlementValue >= currentSettlementValue) {
                        this.setSettlementValueInCurrentProcess(activityContextMap, orderLineIdToChange, currentSettlementValue);
                        continue;
                    }
                    this.setSettlementValueInCurrentProcess(activityContextMap, orderLineIdToChange, settlementValue);
                }
            }
            this.activityService.setActivityContext(orderLinesProcessId, orderLinesActivityId, activityContext);
            this.processService.setProcessContext(orderLinesProcessId, processContext);
        }
    }

    private void setSettlementValueInCurrentProcess(ActivityContextMap activityContextMap, String lineId, Double settlementValue) {
        int foundIndex = -1;
        String[] orderIdsToChange = (String[])activityContextMap.getVariable("nr_linii_zamowienia").getValue();
        for (int i = 0; i < orderIdsToChange.length; ++i) {
            String currentLineId = orderIdsToChange[i];
            if (!StringUtils.equals((String)currentLineId, (String)lineId)) continue;
            foundIndex = i;
            break;
        }
        if (foundIndex > -1) {
            Double[] settlementToChange = (Double[])activityContextMap.getVariable("rozliczona_wartosc_zamo").getValue();
            settlementToChange[foundIndex] = settlementValue;
            activityContextMap.getVariable("rozliczona_wartosc_zamo").setValue((Object)settlementToChange);
        }
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }

    private int getIndexOfValue(List<Map<String, Object>> ordersDataToChange, String orderLineId) {
        int index = -1;
        for (int i = 0; i < ordersDataToChange.size(); ++i) {
            String currentOrderId = (String)ordersDataToChange.get(i).get("orderId");
            if (!StringUtils.equals((String)orderLineId, (String)currentOrderId)) continue;
            index = i;
            break;
        }
        return index;
    }
}

