/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.applications;

import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
public class KSPAcceptTask {
    public static Logger log = Logger.getLogger(KSPAcceptTask.class);
    private String QUERY = "select distinct act.id as activityid, rp.processid from pm_idx_roz_posilko rp join activities act on rp.processId = act.processid where act.activitydefinitionid = 'oczekiwanie_na_rozliczenie' and (act.state = 1000001 OR act.state = 1000003) and numer_rejestracji in (select * from string_split(:registerNo, ';'))";
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("ksp-accept-task-app")).name("Zamykanie zada\u0144 procesu Rozliczanie posi\u0142k\u00f3w ")).description("Zamykanie zada\u0144 procesu Rozliczanie posi\u0142k\u00f3w na podstawie Nr rejestracji.")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.TABLE_SAVE)).parameter().id("registerNo").name("Numery rejestracji").description("Zmienna typu STRING_ARRAY zawierajaca numery rejestracji procesu Rozliczanie posi\u0142k\u00f3w.").type((com.suncode.pwfl.core.type.Type)Types.VARIABLE).create();
    }

    public void execute(@Param Variable registerNo, ApplicationContext context, ActivityContextMap activityContextMap) {
        Assert.isTrue((registerNo.getType() == Types.STRING_ARRAY ? 1 : 0) != 0, (String)("Wrong type of wariable " + registerNo.getId() + ". Only STRING_ARRAY."));
        Object[] uniqueRegisterNo = (String[])Arrays.stream((String[])registerNo.getValue()).distinct().toArray(String[]::new);
        log.debug((Object)("uniqueRegisterNo: " + String.valueOf(Arrays.asList(uniqueRegisterNo))));
        SQLFinder sqlFinder = FinderFactory.getSQLFinder();
        SQLBuilder sqlBuilder = new SQLBuilder();
        sqlBuilder.setQuery(this.QUERY);
        sqlBuilder.addScalar("activityid", (Type)StandardBasicTypes.STRING);
        sqlBuilder.addScalar("processid", (Type)StandardBasicTypes.STRING);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("registerNo", StringUtils.join((Object[])uniqueRegisterNo, (String)";"));
        sqlBuilder.setParameters(params);
        List results = sqlFinder.find(sqlBuilder);
        log.debug((Object)("results: " + String.valueOf(results)));
        for (Map map : results) {
            String activityId = (String)map.get("activityid");
            String processId = (String)map.get("processid");
            Map contextMap = this.activityService.getActivityContext(processId, activityId);
            this.activityService.acceptActivity(new AcceptationDefinition(processId, activityId, "admin", "rozlicz", contextMap, true));
        }
    }
}

