/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.applications;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
public class GenerateCSVFile {
    private Logger log = Logger.getLogger(GenerateCSVFile.class);
    private final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private byte[] BOM = new byte[]{-17, -69, -65};
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentService documentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("generate-csv-file-app")).name("Generowanie pliku CSV tabeli dynamicznej")).description("Generuje plik CSV na podstawie tabeli dynamicznej oraz zapisuje do danej klasy dokument\u00f3w")).category(new Category[]{Categories.DOCUMENTS})).icon((Icon)SilkIconPack.PAGE_GO)).parameter().id("docClassName").name("Nazwa klasy dokument\u00f3w").type((Type)Types.STRING).create()).parameter().id("tableColumnIds").name("Zmienne tabeli dynamicznej").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("fileName").name("Nazwa pliku CSV").type((Type)Types.STRING).create()).parameter().id("fileDesc").name("Opis pliku CSV").type((Type)Types.STRING).create();
    }

    public void execute(@Param String docClassName, @Param Variable[] tableColumnIds, @Param String fileName, @Param String fileDesc, ApplicationContext context, ActivityContextMap activityContextMap, UserInfo userInfo) {
        this.log.trace((Object)"***GenerateCSVFile - start****");
        Assert.isTrue((this.documentClassService.getDocumentClass(docClassName, new String[0]) != null ? 1 : 0) != 0, (String)("Wrong document class name " + docClassName + "."));
        ArrayList<Map<String, String>> columnsData = new ArrayList<Map<String, String>>();
        for (Variable column : tableColumnIds) {
            Assert.isTrue((boolean)column.isArray(), (String)("Wrong variable " + column.getId() + ". Only ARRAY"));
            HashMap<String, String> columnData = new HashMap<String, String>();
            columnData.put("id", column.getId());
            columnData.put("name", column.getName());
            columnsData.add(columnData);
        }
        this.log.debug((Object)("columnsData: " + String.valueOf(columnsData)));
        String content = this.getCSVData(columnsData, activityContextMap);
        this.log.debug((Object)("CSV: " + content));
        WfDocument wfDocument = this.saveInArchive(content, docClassName, userInfo.getUserName(), fileName, fileDesc);
        this.documentService.attachDocumentToProcess(wfDocument, "admin", context.getProcessId(), context.getActivityId());
        this.log.trace((Object)"***GenerateCSVFile - stop****");
    }

    private String getCSVData(List<Map<String, String>> columnsData, ActivityContextMap activityContextMap) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> columnIds = new ArrayList<String>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Map<String, String> map : columnsData) {
            columnNames.add(map.get("name"));
            columnIds.add(map.get("id"));
        }
        StringBuilder headerLine = new StringBuilder("");
        for (String headerName : columnNames) {
            if (headerLine.length() == 0) {
                headerLine.append(headerName);
                continue;
            }
            headerLine.append(";" + headerName);
        }
        lines.add(headerLine.toString());
        String[] stringArray2 = new String[columnIds.size()];
        stringArray2 = columnIds.toArray(stringArray2);
        List table = DynamicTableFunctions.convertFromMapToListOfMaps(this.getContextMap(activityContextMap), (String[])stringArray2);
        for (Map row : table) {
            StringBuilder rowLine = new StringBuilder("");
            for (String columnId : stringArray2) {
                if (rowLine.length() == 0) {
                    rowLine.append((String)row.get(columnId));
                    continue;
                }
                rowLine.append(";" + (String)row.get(columnId));
            }
            lines.add(rowLine.toString());
        }
        Object content = "";
        for (int i = 0; i < lines.size(); ++i) {
            content = i == 0 ? (String)lines.get(i) : (String)content + "\r\n" + (String)lines.get(i);
        }
        return new String(this.BOM) + (String)content;
    }

    private WfDocument saveInArchive(String content, String docClassName, String userName, String fileName, String fileDesc) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass toClass = documentClassService.getDocumentClass(docClassName, new String[0]);
        DocumentService documentService = ServiceFactory.getDocumentService();
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDescription(fileDesc);
        documentDefinition.setDocumentClassId(toClass.getId());
        documentDefinition.setFileName(fileName + ".csv");
        documentDefinition.setUserName(userName);
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(content.getBytes(this.UTF8_CHARSET)));
        return documentService.addDocument(documentDefinition);
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }
}

