/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.colas.applications;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.colas.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class FullfillOrdersCorectionData {
    private Logger log = Logger.getLogger(FullfillOrdersCorectionData.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    private String[] ordersCorrPosTableColumns = new String[]{"lp", "nr_linii_zamowienia", "konto_kosztowe", "nr_projektu", "nazwa_projektu", "segmentacja", "faza", "ilosc", "jednostka", "opis", "cena_jednostkowa", "wartosc", "pozostala_wartosc_do_ro", "wartosc_korygujaca", "process_and_activity_id"};
    private String[] ordersPosTableColumns = new String[]{"id_linii", "konto_kosztowe", "nr_projektu", "nazwa_projektu", "segmentacja", "faza", "ilosc", "jednostka", "opis", "cena_jednostkowa", "wartosc", "wartosc_do_rozliczenia", "status_linii"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("fullfill-orders-corection-data-app")).name("Uzupe\u0142nienie danych dla korekty zam\u00f3wienia")).description("Uzupe\u0142nienie danych dla automatycznie utworzonej korekty zam\u00f3wienia")).category(new Category[]{Categories.CLIENT})).icon((Icon)SilkIconPack.TABLE_ADD)).parameter().id("sourceProcessId").name("Id procesu Rejestracji zam\u00f3wienia").description("Identyfikator procesu, z kt\u00f3rego zostan\u0105 pobrane dane").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap activityContextMap, @Param String sourceProcessId) throws Exception {
        this.log.trace((Object)"***FullfillOrdersCorectionData - start****");
        Map<String, Object> corrOrderContextMap = this.getContextMap(activityContextMap);
        this.log.debug((Object)("corrOrderContextMap: " + String.valueOf(corrOrderContextMap)));
        this.log.debug((Object)("sourceProcessId: " + sourceProcessId));
        Map orderContextMap = this.processService.getProcessContext(sourceProcessId);
        this.log.debug((Object)("orderContextMap: " + String.valueOf(orderContextMap)));
        String company = (String)orderContextMap.get("spolka");
        corrOrderContextMap.put("spolka", company);
        String supplieVatNo = (String)orderContextMap.get("nip_dostawcy");
        corrOrderContextMap.put("nip_dostawcy", supplieVatNo);
        String supplieNo = (String)orderContextMap.get("nr_dostawcy");
        corrOrderContextMap.put("nr_dostawcy", supplieNo);
        String supplierName = (String)orderContextMap.get("nazwa_dostawcy");
        corrOrderContextMap.put("nazwa_dostawcy", supplierName);
        String address = (String)orderContextMap.get("adres");
        corrOrderContextMap.put("adres", address);
        String orderNo = (String)orderContextMap.get("nr_zamowienia");
        corrOrderContextMap.put("nr_zamowienia_korygowan", orderNo);
        String correctionDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        corrOrderContextMap.put("data_korekty", correctionDate);
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("status_linii", "Do realizacji");
        Map foundRecords = DynamicTableFunctions.findRecordsAllConditions((Map)orderContextMap, (String[])this.ordersPosTableColumns, conditions);
        this.log.debug((Object)("foundRecords: " + String.valueOf(foundRecords)));
        Double correctionSum = new Double(0.0);
        List orderRecordsToPut = DynamicTableFunctions.convertFromMapToListOfMaps((Map)foundRecords, (String[])this.ordersPosTableColumns);
        for (int i = 0; i < orderRecordsToPut.size(); ++i) {
            Map row = (Map)orderRecordsToPut.get(i);
            HashMap<String, Object> toAdd = new HashMap<String, Object>();
            toAdd.put("lp", String.valueOf(i + 1));
            toAdd.put("nr_linii_zamowienia", (String)row.get("id_linii"));
            toAdd.put("konto_kosztowe", (String)row.get("konto_kosztowe"));
            toAdd.put("nr_projektu", (String)row.get("nr_projektu"));
            toAdd.put("nazwa_projektu", (String)row.get("nazwa_projektu"));
            toAdd.put("segmentacja", (String)row.get("segmentacja"));
            toAdd.put("faza", (String)row.get("faza"));
            toAdd.put("ilosc", (String)row.get("ilosc"));
            toAdd.put("jednostka", (String)row.get("jednostka"));
            toAdd.put("opis", (String)row.get("opis"));
            toAdd.put("cena_jednostkowa", (String)row.get("cena_jednostkowa"));
            toAdd.put("wartosc", (String)row.get("wartosc"));
            toAdd.put("pozostala_wartosc_do_ro", (String)row.get("wartosc_do_rozliczenia"));
            Double corrValue = -1.0 * Double.valueOf((String)row.get("wartosc_do_rozliczenia"));
            toAdd.put("wartosc_korygujaca", corrValue.toString());
            toAdd.put("process_and_activity_id", orderContextMap.get("ProccessId").toString() + "#" + orderContextMap.get("ActivityId").toString());
            correctionSum = correctionSum + corrValue;
            corrOrderContextMap.putAll(DynamicTableFunctions.addRecords(corrOrderContextMap, (String[])this.ordersCorrPosTableColumns, toAdd));
        }
        this.log.debug((Object)("correctionSum: " + correctionSum));
        corrOrderContextMap.put("wartosc_korekty", correctionSum);
        this.activityService.setActivityContext(activityContextMap.getProcessId(), activityContextMap.getActivityId(), corrOrderContextMap);
        this.processService.setProcessContext(activityContextMap.getProcessId(), corrOrderContextMap);
        this.log.debug((Object)("corrOrderContextMap: " + String.valueOf(corrOrderContextMap)));
        this.log.trace((Object)"***FullfillOrdersCorectionData - end****");
    }

    private Map<String, Object> getContextMap(ActivityContextMap activityContextMap) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map context = activityContextMap.getVariables();
        for (String key : context.keySet()) {
            Variable variable = (Variable)context.get(key);
            if (variable.isArray()) {
                Object[] objectArray = (Object[])variable.getValue();
                contextMap.put(variable.getId(), StringUtils.join((Object[])objectArray, (String)";"));
                continue;
            }
            contextMap.put(variable.getId(), variable.getValue());
        }
        return contextMap;
    }
}

