/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.change_users_logins;

import com.plusmpm.util.UsersManagement;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.ComponentFactory;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.QueryExecutor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.hibernate.SQLQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@ScheduledTask
@Transactional
public class ChangeUsersLogins {
    private Logger log = Logger.getLogger(this.getClass());

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("change-users-login-scheduled-task")).name("change.users.login.scheduled.task.name")).description("change.users.login.scheduled.task.desc")).parameter().id("filepath").name("change.users.login.scheduled.task.param.filepath.name").description("change.users.login.scheduled.task.param.filepath.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("sheetname").name("change.users.login.scheduled.task.param.sheetname.name").description("change.users.login.scheduled.task.param.sheetname.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("old-logins-column-name").name("change.users.login.scheduled.task.param.old-logins-column-name.name").description("change.users.login.scheduled.task.param.old-logins-column-name.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("new-logins-column-name").name("change.users.login.scheduled.task.param.new-logins-column-name.name").description("change.users.login.scheduled.task.param.new-logins-column-name.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("cust-tables-names").name("change.users.login.scheduled.task.param.cust-tables-names.name").description("change.users.login.scheduled.task.param.cust-tables-names.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).optional().create()).parameter().id("cust-table-columns-names").name("change.users.login.scheduled.task.param.cust-table-columns-names.name").description("change.users.login.scheduled.task.param.cust-table-columns-names.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).optional().create()).parameter().id("from-hour").name("change.users.login.scheduled.task.param.from-hour.name").description("change.users.login.scheduled.task.param.from-hour.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("to-hour").name("change.users.login.scheduled.task.param.to-hour.name").description("change.users.login.scheduled.task.param.to-hour.desc").type((com.suncode.pwfl.core.type.Type)Types.STRING).create();
    }

    public void execute(Logger taskLog, @Param String filepath, @Param String sheetname, @Param(value="old-logins-column-name") String oldLoginsColumnName, @Param(value="new-logins-column-name") String newLoginsColumnName, @Param(value="cust-tables-names") String custTablesNamesToSplit, @Param(value="cust-table-columns-names") String custTableColumnsNamesToSplit, @Param(value="from-hour") String fromHourToSplit, @Param(value="to-hour") String toHourToSplit) throws Exception {
        int oldLoginsColumnNumber = -1;
        int newLoginsColumnNumber = -1;
        ArrayList<String> oldLogins = new ArrayList<String>();
        ArrayList<String> newLogins = new ArrayList<String>();
        List<String> custTablesNames = Arrays.asList(custTablesNamesToSplit.split(";"));
        List<String> custTableColumnsNames = Arrays.asList(custTableColumnsNamesToSplit.split(";"));
        if (custTableColumnsNames.size() != custTablesNames.size()) {
            String message = "Tables and columns parameters has different sizes!";
            taskLog.error((Object)message);
            throw new Exception(message);
        }
        HashMap<String, ArrayList<String>> custTablesMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < custTablesNames.size(); ++i) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(custTableColumnsNames.get(i).split("&")));
            custTablesMap.put(custTablesNames.get(i), list);
        }
        String[] fromHour = fromHourToSplit.split(":");
        String[] toHour = toHourToSplit.split(":");
        ArrayList<Integer> availHours = new ArrayList<Integer>();
        int it = (Integer.parseInt(fromHour[0]) + 1) % 24;
        while (it != Integer.parseInt(toHour[0])) {
            availHours.add(it);
            it = (it + 1) % 24;
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)new FileInputStream(filepath));
        }
        catch (Exception e) {
            String message = "File " + filepath + " not found!";
            taskLog.error((Object)message);
            this.log.error((Object)message);
            throw e;
        }
        boolean sheetFound = false;
        for (Sheet sheet : wb) {
            String message;
            if (!sheet.getSheetName().equalsIgnoreCase(sheetname)) continue;
            sheetFound = true;
            taskLog.info((Object)("Found sheet: " + sheetname));
            Row firstRow = sheet.getRow(0);
            for (Cell cell : firstRow) {
                if (cell.getStringCellValue().equals(oldLoginsColumnName)) {
                    oldLoginsColumnNumber = cell.getColumnIndex();
                    continue;
                }
                if (!cell.getStringCellValue().equals(newLoginsColumnName)) continue;
                newLoginsColumnNumber = cell.getColumnIndex();
            }
            if (oldLoginsColumnNumber < 0) {
                message = "Column with name: " + oldLoginsColumnName + " not found in sheet!";
                taskLog.error((Object)message);
                throw new Exception(message);
            }
            if (newLoginsColumnNumber < 0) {
                message = "Column with name: " + newLoginsColumnName + " not found in sheet!";
                taskLog.error((Object)message);
                throw new Exception(message);
            }
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                if (sheet.getRow(i).getCell(oldLoginsColumnNumber) != null) {
                    oldLogins.add(sheet.getRow(i).getCell(oldLoginsColumnNumber).toString());
                }
                if (sheet.getRow(i).getCell(newLoginsColumnNumber) == null) continue;
                newLogins.add(sheet.getRow(i).getCell(newLoginsColumnNumber).toString());
            }
            if (oldLogins.size() != newLogins.size()) {
                String message2 = "Logins columns has different sizes!";
                taskLog.error((Object)message2);
                throw new Exception(message2);
            }
            Boolean run = false;
            UsersManagement um = new UsersManagement();
            SQLFinder finder = FinderFactory.getSQLFinder();
            SQLBuilder builder = new SQLBuilder();
            ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
            for (int i = 0; i < oldLogins.size(); ++i) {
                while (!run.booleanValue()) {
                    if (this.isInAvailHours(availHours, fromHour, toHour).booleanValue()) {
                        run = true;
                        continue;
                    }
                    Thread.sleep(60000L);
                }
                if (i == 0) {
                    taskLog.info((Object)("Activated at: " + new DateTime()));
                }
                taskLog.info((Object)("[" + (i + 1) + "/" + oldLogins.size() + "] Replacing user's name: '" + (String)oldLogins.get(i) + "' with: '" + (String)newLogins.get(i) + "'"));
                um.ChangeUserLogin((String)oldLogins.get(i), (String)newLogins.get(i), "admin");
                builder.setQuery("SELECT objectid FROM usertable WHERE userid = '" + (String)oldLogins.get(i) + "'");
                builder.addScalar("objectid", (Type)StandardBasicTypes.INTEGER);
                List list = finder.find(builder);
                if (list.size() != 0) {
                    String message3 = "Login " + (String)newLogins.get(i) + " contains illegal characters. Skipping login change.";
                    this.log.warn((Object)message3);
                    taskLog.warn((Object)message3);
                    idsToRemove.add(i);
                }
                if ((run = this.isInAvailHours(availHours, fromHour, toHour)).booleanValue()) continue;
                DateTime dt = new DateTime();
                taskLog.info((Object)("Executing paused at: " + dt));
            }
            Iterator<Object> iterator = idsToRemove.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                oldLogins.remove(n);
                newLogins.remove(n);
            }
            for (Map.Entry entry : custTablesMap.entrySet()) {
                for (String s : (List)entry.getValue()) {
                    for (int i = 0; i < oldLogins.size(); ++i) {
                        taskLog.info((Object)("Replacing user's name: '" + (String)oldLogins.get(i) + "' with: '" + (String)newLogins.get(i) + "' in custom table: '" + (String)entry.getKey() + "', column: '" + s + "'"));
                        String updateQuery = "UPDATE " + (String)entry.getKey() + " SET " + s + " = '" + (String)newLogins.get(i) + "' WHERE " + s + " = '" + (String)oldLogins.get(i) + "'";
                        this.executeQuery(updateQuery);
                    }
                }
            }
        }
        if (!sheetFound) {
            String message = "Sheet not found!";
            taskLog.error((Object)message);
            this.log.error((Object)message);
            throw new Exception("Sheet not found!");
        }
    }

    private Boolean isInAvailHours(List<Integer> availHours, String[] fromHour, String[] toHour) {
        DateTime dt = new DateTime();
        if (fromHour[0].equals(toHour[0])) {
            return availHours.contains(dt.getHourOfDay()) || Integer.parseInt(fromHour[0]) == dt.getHourOfDay() && Integer.parseInt(fromHour[1]) <= dt.getMinuteOfHour() && Integer.parseInt(toHour[0]) == dt.getHourOfDay() && Integer.parseInt(toHour[1]) >= dt.getMinuteOfHour();
        }
        return availHours.contains(dt.getHourOfDay()) || Integer.parseInt(fromHour[0]) == dt.getHourOfDay() && Integer.parseInt(fromHour[1]) <= dt.getMinuteOfHour() || Integer.parseInt(toHour[0]) == dt.getHourOfDay() && Integer.parseInt(toHour[1]) >= dt.getMinuteOfHour();
    }

    private void executeQuery(final String query) {
        TransactionTemplate tt = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                QueryExecutor qe = ComponentFactory.getQueryExecutor();
                SQLQuery sql = qe.createSQLQuery(query);
                sql.executeUpdate();
            }
        });
    }
}

