/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.subprocess;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.CUF.util.extension.SharkClientFunctions;
import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;

@Application
public class UpdateMainProcess {
    public static Logger log = Logger.getLogger(UpdateMainProcess.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("updateMasterProcess")).name("Update master process from subprocess")).description("")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).category(new Category[]{Categories.CARGOTEC})).parameter().id("subProcessId").name("Id podprocesu").description("").type((Type)Types.STRING).create()).parameter().id("subProcessDefId").name("Id definicji podprocesu").description("").type((Type)Types.STRING).create()).parameter().id("processDefId").name("Id definicji procesu g\u0142\u00f3wnego").description("").type((Type)Types.STRING).create()).parameter().id("buforTaskId").name("Id zadania buforowego").description("W procesie g\u0142\u00f3wnym").type((Type)Types.STRING).create()).parameter().id("idVarId").name("Zmienna identyfikuj\u0105ca proces (ID)").description("Id zmiennej identyfikuj\u0105cej proces g\u0142\u00f3wny, umo\u017cliwiaj\u0105ca odszukanie go w bazie otwartych proces\u00f3w").type((Type)Types.STRING).create()).parameter().id("idVarValue").name("Warto\u015b\u0107 zmiennej identyfikuj\u0105cej").description("Zmienna identyfikuj\u0105ca proces g\u0142\u00f3wny, umo\u017cliwiaj\u0105ca odszukanie go w bazie otwartych proces\u00f3w").type((Type)Types.STRING).create()).parameter().id("subVars").name("Zmienne podprocesu").description("Kolejno\u015b\u0107 jak zmiennych procesu g\u0142\u00f3wnego").type((Type)Types.STRING_ARRAY).create()).parameter().id("mainVars").name("Zmienne procesu g\u0142\u00f3wnego").description("Kolejno\u015b\u0107 jak zmiennych podprocesu").type((Type)Types.STRING_ARRAY).create()).parameter().id("keyVar").name("Zmienna identyfikuj\u0105ca rekord (ID)").description("Zmienna s\u0142u\u017c\u0105ca do identyfikacji wiersza w procesie g\u0142\u00f3wnym, musi takie samo ID").type((Type)Types.STRING).create()).parameter().id("copyComments").name("Czy kopiowa\u0107 komentarze?").description("").type((Type)Types.BOOLEAN).create()).parameter().id("actionName").name("Akcja akceptacji").description("Id akcji do wykonania w trakcie akceptowania zadania buforowego").type((Type)Types.STRING).create();
    }

    public static synchronized void execute(@Param String subProcessId, @Param String subProcessDefId, @Param String processDefId, @Param String buforTaskId, @Param String idVarId, @Param String idVarValue, @Param String[] subVars, @Param String[] mainVars, @Param String keyVar, @Param Boolean copyComments, @Param String actionName) {
        try {
            log.debug((Object)"UpdateMainProcess started...");
            ProcessService ps = ServiceFactory.getProcessService();
            ProcessFinder pf = FinderFactory.getProcessFinder();
            ActivityService as = ServiceFactory.getActivityService();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Process mainProcess = null;
            HashMap<String, String> indexes = new HashMap<String, String>();
            indexes.put(idVarId, idVarValue);
            List processes = pf.findByIndexes(processDefId, indexes, new String[0]);
            if (processes.size() == 1) {
                mainProcess = (Process)processes.get(0);
            } else if (processes.size() <= 0) {
                log.error((Object)"Main process not found...");
            } else {
                log.error((Object)"Found more than one process!");
                throw new Exception("Found more than one process!");
            }
            if (subVars.length != mainVars.length) {
                throw new Exception("Number of variables in subprocess is different than in main process!");
            }
            String mainProcessId = mainProcess.getProcessId();
            Map subProcessctx = ps.getProcessContext(subProcessId);
            Map mainProcessCtx = SharkClientFunctions.getProcessContextMap((String)mainProcessId);
            List mainProcessTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)mainProcessCtx, (String[])mainVars);
            String subRowId = (String)subProcessctx.get(keyVar);
            log.debug((Object)("Subprocess key: " + subRowId));
            String value = "";
            for (Map mainProcessTableRow : mainProcessTable) {
                String mainRowId = (String)mainProcessTableRow.get(keyVar);
                log.debug((Object)("Main process key: " + mainRowId));
                if (subRowId.compareTo(mainRowId) != 0) continue;
                for (int i = 0; i < subVars.length; ++i) {
                    log.debug((Object)(mainVars[i] + " / " + String.valueOf(subProcessctx.get(subVars[i]))));
                    if (subProcessctx.get(subVars[i]) instanceof String) {
                        value = (String)subProcessctx.get(subVars[i]);
                        log.debug((Object)(mainVars[i] + ", value: " + value));
                    } else if (subProcessctx.get(subVars[i]) instanceof Double) {
                        value = Double.toString((Double)subProcessctx.get(subVars[i]));
                        log.debug((Object)(mainVars[i] + ", value: " + value));
                    } else if (subProcessctx.get(subVars[i]) instanceof Integer) {
                        value = Integer.toString((Integer)subProcessctx.get(subVars[i]));
                        log.debug((Object)(mainVars[i] + ", value: " + value));
                    } else if (subProcessctx.get(subVars[i]) instanceof Long) {
                        value = Long.toString((Long)subProcessctx.get(subVars[i]));
                        log.debug((Object)(mainVars[i] + ", value: " + value));
                    } else if (subProcessctx.get(subVars[i]) instanceof LocalDate) {
                        value = sdf.format(subProcessctx.get(subVars[i]));
                        log.debug((Object)(mainVars[i] + ", value: " + value));
                    }
                    mainProcessTableRow.put(mainVars[i], value);
                }
            }
            Map oneTableRows = DynamicTableFunctions.convertFromListOfMapsToMap((List)mainProcessTable, (String[])mainVars);
            for (int i = 0; i < mainVars.length; ++i) {
                log.debug((Object)(mainVars[i] + " : " + oneTableRows.get(mainVars[i]).toString()));
                mainProcessCtx.put(mainVars[i], oneTableRows.get(mainVars[i]));
            }
            log.debug((Object)"Copy variables finished.");
            if (copyComments.booleanValue()) {
                P0045Tools.copyCommentsFromOneProcessToAnother(subProcessId, mainProcessId);
            }
            boolean toApprove = true;
            List subprocesses = pf.findByIndexes(subProcessDefId, indexes, new String[0]);
            log.debug((Object)("Found subprocesses: " + subprocesses.size()));
            for (Process oneSubProcess : subprocesses) {
                if (oneSubProcess.getProcessId().equalsIgnoreCase(subProcessId) || !UpdateMainProcess.isOpen(oneSubProcess.getState())) continue;
                toApprove = false;
            }
            ps.setProcessContext(mainProcess.getProcessId(), mainProcessCtx);
            log.debug((Object)("To approve: " + toApprove));
            if (toApprove) {
                P0045Tools.acceptActivity(mainProcessId, buforTaskId, mainProcessCtx, actionName);
            } else {
                log.debug((Object)"There is other open process. Finishing task UpdateMainProcess...");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isOpen(ProcessState state) {
        return state.equals((Object)ProcessState.RUNNING) || state.equals((Object)ProcessState.NOT_STARTED) || state.equals((Object)ProcessState.SUSPENDED);
    }
}

