/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.servlet.eo;

import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import com.plusmpm.util.virtualtables.Record;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VRecord;
import com.plusmpm.util.virtualtables.VTable;
import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class P0045LoadDataFromXlsx
extends HttpServlet {
    public static Logger log = Logger.getLogger(P0045LoadDataFromXlsx.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
    }

    public void init() throws ServletException {
        super.init();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* P0045LoadDataFromXlsx DO GET ****************************");
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.trace((Object)"************************* P0045LoadDataFromXlsx ****************************");
        PrintWriter printWriter = null;
        ArrayList<Map> jsonRecords = new ArrayList<Map>();
        JSONObject jsObj = new JSONObject();
        try {
            String colNames = request.getParameter("cols");
            String colIds = request.getParameter("colIds");
            String[] columnNames = colNames.split(";");
            String[] columnIds = colIds.split(";");
            String path = this.pobierzSciezkePlikuTymczasowego();
            if (path != null && path.compareTo("") != 0) {
                Part filePart = request.getPart("file");
                String fileName = Paths.get(filePart.getSubmittedFileName(), new String[0]).getFileName().toString();
                String uploadPath = path + fileName;
                File uploadedFile = new File(uploadPath);
                try (InputStream fileContent = filePart.getInputStream();
                     FileOutputStream fos = new FileOutputStream(uploadPath);){
                    int n;
                    byte[] buffer = new byte[1024];
                    while ((n = fileContent.read(buffer)) != -1) {
                        fos.write(buffer, 0, n);
                    }
                }
                ArrayList<String> columns = new ArrayList<String>();
                Collections.addAll(columns, columnNames);
                ArrayList<Map<String, String>> listOfRows = P0045Tools.importDataFromXlsxFile(uploadPath, columns, 0);
                for (Map map : listOfRows) {
                    String[] part_type_additional_data;
                    for (int i = 0; i < columnNames.length; ++i) {
                        map.put(columnIds[i], (String)map.get(columnNames[i]));
                        map.remove(columnNames[i]);
                    }
                    String part_type = (String)map.get("part_type");
                    if (part_type.compareTo("") != 0 && ((part_type_additional_data = this.getPartTypeAdditionalData(part_type))[0].compareTo("") == 0 || part_type_additional_data[1].compareTo("") == 0)) {
                        map.put("part_type", "");
                        map.put("sourcing_needed", "");
                        map.put("logistic_needed", "");
                    }
                    String responsible_sourcing = (String)map.get("responsible_sourcing");
                    String responsible_sourcing_login = "";
                    if (responsible_sourcing != null && responsible_sourcing.compareTo("") != 0) {
                        responsible_sourcing_login = this.pobierzLoginUzytkownikaPoDanych(responsible_sourcing);
                    }
                    map.put("responsible_sourcing_login", responsible_sourcing_login);
                    String responsible_logistics = (String)map.get("responsible_logistics");
                    String responsible_logistics_login = "";
                    if (responsible_logistics != null && responsible_logistics.compareTo("") != 0) {
                        responsible_logistics_login = this.pobierzLoginUzytkownikaPoDanych(responsible_logistics);
                    }
                    map.put("responsible_logistics_login", responsible_logistics_login);
                    jsonRecords.add(map);
                }
                uploadedFile.delete();
            }
            jsObj.append("success", (Object)true);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            jsonRecords = new ArrayList();
            try {
                jsObj.append("success", (Object)false);
            }
            catch (JSONException ex) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            JsonStore jsonStore = new JsonStore();
            jsonStore.setRecords(jsonRecords);
            GsonCustomUtils gsonCustomUtils = new GsonCustomUtils();
            String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
            try {
                jsObj.put("data", (Object)sJsonData);
            }
            catch (JSONException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            printWriter = response.getWriter();
            HashMap<String, Boolean> responseMap = new HashMap<String, Boolean>();
            responseMap.put("success", true);
            printWriter.print(jsObj.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pobierzLoginUzytkownikaPoDanych(String userdata) {
        String login = "";
        Connection con = null;
        String query = "SELECT userid FROM usertable WHERE (firstname + ' ' + lastname) = '" + userdata + "'";
        try {
            con = InternalDataBase.connect();
            ArrayList list = InternalDataBase.executeQuery((Connection)con, (String)query);
            if (list != null && list.size() == 1) {
                login = (String)((HashMap)list.get(0)).get("userid");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                InternalDataBase.distconnect((Connection)con);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return login;
    }

    private String pobierzSciezkePlikuTymczasowego() {
        String path = SystemProperties.getString((String)"TEMPORARY_FILES_FOLDER");
        return path;
    }

    private String[] getPartTypeAdditionalData(String part_type_name) {
        String[] answer = new String[]{"", ""};
        if (part_type_name != null && part_type_name.compareTo("") != 0 && VTable.exists((String)"tab_part_types") && VColumn.exists((String)"tab_part_types", (String)"col_part_type") && VColumn.exists((String)"tab_part_types", (String)"col_sourcing") && VColumn.exists((String)"tab_part_types", (String)"col_logistic")) {
            ArrayList records = VRecord.getRecordsWhere((String)"tab_part_types", (String)"col_part_type", (String)part_type_name);
            for (Record rec : records) {
                String sourcing_needed = (String)rec.getValue("col_sourcing");
                String logistic_needed = (String)rec.getValue("col_logistic");
                if (sourcing_needed.compareTo("Yes") != 0 && sourcing_needed.compareTo("No") != 0 || logistic_needed.compareTo("Yes") != 0 && logistic_needed.compareTo("No") != 0) continue;
                answer[0] = sourcing_needed;
                answer[1] = logistic_needed;
            }
        }
        return answer;
    }
}

