/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduledtasks;

import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.XMLTools;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ScheduledTask
public class VerifyFailedOtmFiles {
    public static Logger log = Logger.getLogger(VerifyFailedOtmFiles.class);
    private static String[] tagsToRead = new String[]{"OtmInvoiceId", "OtmVoucherId", "OtmDomainName", "ImageFile"};

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("verifyFailedOtmFiles")).name("Verify failed OTM files")).description("")).cancelable().parameter().id("path").name("Error files path").description("").type((Type)Types.STRING).create();
    }

    public void execute(@Param(value="path") String path) {
        try {
            File[] filesForProcessing;
            Object sError = "Error while processing file: ";
            for (File file : filesForProcessing = P0045Tools.getOrderedListOfFiles(new File(path))) {
                Map<String, String> datatoXml = VerifyFailedOtmFiles.processSingleFile(file);
                sError = StringUtils.isBlank((CharSequence)datatoXml.get("ImageFile")) ? (String)sError + " image file not found" : (String)sError + "unknown";
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("otm_invoice_id", datatoXml.get("OtmInvoiceId"));
                data.put("otm_voucher_id", datatoXml.get("OtmVoucherId"));
                data.put("otm_domain_name", datatoXml.get("OtmDomainName"));
                data.put("workflow_invoice_id", "");
                data.put("import_status", "ERROR");
                data.put("approval_status", "");
                data.put("error_log", (String)sError);
                String filePath = SystemProperties.getString((String)"OTM_EXPORT_FILE_PATH");
                XMLTools.generateOTMResponse(filePath, data);
                file.delete();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, String> processSingleFile(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        HashMap<String, String> valuesForXml = new HashMap<String, String>();
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            for (String tag : tagsToRead) {
                NodeList list = doc.getElementsByTagName(tag);
                if (list.getLength() == 0) {
                    valuesForXml.put(tag, "");
                }
                for (int temp = 0; temp < list.getLength(); ++temp) {
                    Node node = list.item(temp);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String nodeTxt = element.getTextContent();
                    valuesForXml.put(tag, nodeTxt);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return valuesForXml;
    }
}

