/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduledtasks;

import com.plusmpm.util.MathFunctions;
import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.scheduledtasks.GeneratePoForBusinessTrip;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@ScheduledTask
public class VerifyBusinessTripPoAfterReturn {
    public static Logger log = Logger.getLogger(VerifyBusinessTripPoAfterReturn.class);

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("VerifyBusinessTripPoAfterReturn")).name("Weryfikacja PO dla procesu Business Trip")).description("")).cancelable().parameter().id("processDefId").name("Id definicji procesu").description("").type((Type)Types.STRING).create()).parameter().id("checkTaskId").name("Id zadania buforowego").description("").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="processDefId") String processDefId, @Param(value="checkTaskId") String checkTaskId) {
        log.debug((Object)("VerifyBusinessTripPoAfterReturn for task: " + checkTaskId));
        ActivityService as = ServiceFactory.getActivityService();
        ProcessService ps = ServiceFactory.getProcessService();
        try {
            ArrayList<Activity> allTasksToCheck = P0045Tools.findOpenActivitiesForId(processDefId, checkTaskId);
            log.debug((Object)("Found " + allTasksToCheck.size() + " tasks at bufor step..."));
            String poAction = "";
            for (Activity activity : allTasksToCheck) {
                log.debug((Object)("Verification of: " + activity.getActivityId()));
                try {
                    Map ctx = as.getActivityContext(activity.getProcessId(), activity.getActivityId());
                    String pr_no = (String)ctx.get("pr_no");
                    String[] total_value = ctx.get("total_value").toString().split(";", -1);
                    ArrayList<String> descrip = new ArrayList<String>();
                    ArrayList<String> newUnitPrice = new ArrayList<String>();
                    ArrayList<String> newTotalValue = new ArrayList<String>();
                    ArrayList<String> newProductCode = new ArrayList<String>();
                    ArrayList<String> newProductName = new ArrayList<String>();
                    ArrayList<String> newGlAccount = new ArrayList<String>();
                    ArrayList<String> newGlDescr = new ArrayList<String>();
                    ArrayList<String> newComment = new ArrayList<String>();
                    double total = 0.0;
                    double total_pln = 0.0;
                    double dAmount = 0.0;
                    boolean poHigher = false;
                    boolean poLower = false;
                    boolean noChange = false;
                    String bt_process_id = (String)ctx.get("bt_process_id");
                    ArrayList<Activity> btTasksToCheck = P0045Tools.findOpenActivitiesForId("business_tr", "waiting_for_pr_approval");
                    Activity btActivity = null;
                    for (Activity act : btTasksToCheck) {
                        if (!act.getProcessId().equalsIgnoreCase(bt_process_id)) continue;
                        btActivity = act;
                        break;
                    }
                    if (btActivity != null) {
                        Map btCtx = as.getActivityContext(btActivity.getProcessId(), btActivity.getActivityId());
                        String sDelegationNo = (String)btCtx.get("business_travel_no");
                        String[] tTypeOfCost = btCtx.get("type_of_cost").toString().split(";", -1);
                        String[] tCostCurrency = btCtx.get("cost_currency_booking").toString().split(";", -1);
                        String[] tCostValue = btCtx.get("cost_value").toString().split(";", -1);
                        String[] tGeneratePo = btCtx.get("generate_po").toString().split(";", -1);
                        String[] tGeneratedPrPo = btCtx.get("generated_prpo_no").toString().split(";", -1);
                        CharSequence[] tApprovalRequired = btCtx.get("approval_required").toString().split(";", -1);
                        String[] tCcNo = btCtx.get("cc_no_cost").toString().split(";", -1);
                        String[] tCcHolder = btCtx.get("cc_holder_cost").toString().split(";", -1);
                        String[] tProductCode = btCtx.get("product_code_cost").toString().split(";", -1);
                        String[] tProductName = btCtx.get("product_name_cost").toString().split(";", -1);
                        String[] tGlAccount = btCtx.get("gl_account").toString().split(";", -1);
                        String[] tGlDescription = btCtx.get("gl_description").toString().split(";", -1);
                        String[] tComment = btCtx.get("comment_tab").toString().split(";", -1);
                        int pCount = 0;
                        String currency = (String)ctx.get("currency");
                        for (int i = 0; i < tCostValue.length; ++i) {
                            log.debug((Object)(pr_no + " | " + tGeneratedPrPo[i] + " | " + tGeneratePo[i] + " | " + (String)tApprovalRequired[i]));
                            if (!pr_no.equalsIgnoreCase(tGeneratedPrPo[i]) || !tGeneratePo[i].equalsIgnoreCase("yes")) continue;
                            if (((String)tApprovalRequired[i]).matches("Yes.*higher")) {
                                poAction = "value_higher";
                                poHigher = true;
                            } else if (((String)tApprovalRequired[i]).matches("Yes.*lower")) {
                                poAction = "value_lower";
                                poLower = true;
                            } else if (((String)tApprovalRequired[i]).equalsIgnoreCase("No")) {
                                poAction = "no_change";
                                noChange = true;
                            } else {
                                poAction = "";
                            }
                            log.debug((Object)poAction);
                            if (poAction.equalsIgnoreCase("value_higher") || poAction.equalsIgnoreCase("value_lower")) {
                                newUnitPrice.add(tCostValue[i]);
                                newTotalValue.add(tCostValue[i]);
                                dAmount = MathFunctions.round((double)Double.valueOf(tCostValue[i]), (int)2);
                                total = MathFunctions.round((double)(total + dAmount), (int)2);
                                tApprovalRequired[i] = "No";
                            } else {
                                newUnitPrice.add(total_value[pCount]);
                                newTotalValue.add(total_value[pCount]);
                                dAmount = MathFunctions.round((double)Double.valueOf(tCostValue[i]), (int)2);
                                total = MathFunctions.round((double)(total + dAmount), (int)2);
                            }
                            log.debug((Object)tCostCurrency[i]);
                            currency = tCostCurrency[i];
                            ctx.put("currency", tCostCurrency[i]);
                            ctx.put("cost_center_no", tCcNo[i]);
                            ctx.put("cost_center", GeneratePoForBusinessTrip.getCCName(tCcNo[i]));
                            ctx.put("department_manager", tCcHolder[i]);
                            descrip.add(sDelegationNo.concat(" ").concat(tTypeOfCost[i]));
                            newProductCode.add(tProductCode[i]);
                            newProductName.add(tProductName[i]);
                            newGlAccount.add(tGlAccount[i]);
                            newGlDescr.add(tGlDescription[i]);
                            newComment.add(tComment[i]);
                            ++pCount;
                        }
                        btCtx.put("approval_required", String.join((CharSequence)";", tApprovalRequired));
                        ps.setProcessContext(btActivity.getProcessId(), btCtx);
                        as.setActivityContext(btActivity.getProcessId(), btActivity.getActivityId(), btCtx);
                        log.debug((Object)("Updated BT: " + btActivity.getProcessId() + " | " + btActivity.getActivityId()));
                        SimpleDateFormat workflowDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date currentDate = new Date();
                        String sCurrentDate = workflowDateFormat.format(currentDate);
                        String sRate = Double.toString(P0045Tools.getCurrencyRateFromNbp(currency, sCurrentDate));
                        double dRate = 0.0;
                        if (!StringUtils.isBlank((CharSequence)sRate)) {
                            dRate = Double.parseDouble(sRate);
                            log.debug((Object)(total + " * " + dRate));
                            total_pln = MathFunctions.round((double)(total * dRate), (int)2);
                        }
                        ctx.put("total", total);
                        ctx.put("pr_total_value_in_pln", total_pln);
                        ctx.put("total_in_pln", total_pln);
                        ctx.put("unit_net_price", String.join((CharSequence)";", newUnitPrice));
                        ctx.put("total_value", String.join((CharSequence)";", newTotalValue));
                        ctx.put("descrip", String.join((CharSequence)";", descrip));
                        ctx.put("product_code", String.join((CharSequence)";", newProductCode));
                        ctx.put("product_name", String.join((CharSequence)";", newProductName));
                        ctx.put("gl_account", String.join((CharSequence)";", newGlAccount));
                        ctx.put("gl_descr", String.join((CharSequence)";", newGlDescr));
                        ctx.put("comments", String.join((CharSequence)";", newComment));
                    }
                    log.debug((Object)(poHigher + " " + poLower + " " + noChange));
                    String action = "";
                    if (poHigher) {
                        action = "value_higher";
                    } else if (poLower) {
                        action = "value_lower";
                    } else if (noChange) {
                        action = "no_change";
                    }
                    if (!StringUtils.isBlank((CharSequence)action)) {
                        P0045Tools.acceptActivity(activity.getProcessId(), activity.getActivityDefinitionId(), ctx, action);
                        continue;
                    }
                    log.debug((Object)"No changes, no action needed...");
                }
                catch (Exception e) {
                    log.error((Object)("Error for: " + activity.getActivityId()));
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            log.debug((Object)"VerifyBusinessTripPoAfterReturn finished.");
        }
    }
}

