/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduledtasks;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.hibernate.Session;

@ScheduledTask
public class ImportItemDataFromXLS {
    public static Logger log = Logger.getLogger(ImportItemDataFromXLS.class);
    private static ArrayList<String> columns = new ArrayList();
    private static ArrayList<String> dbColumns = new ArrayList();

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("importItemDataFromXLS")).name("Import danych item\u00f3w")).description("Import danych item\u00f3w")).cancelable().parameter().id("xlsFilePath").name("\u015acie\u017cka do XLS").description("\u015acie\u017cka do XLS").type((Type)Types.STRING).create()).cancelable().parameter().id("tableName").name("Nazwa tabeli").description("Nazwa tabeli").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="xlsFilePath") String xlsFilePath, @Param(value="tableName") String tableName) {
        columns.addAll(Arrays.asList("Item", "Revision", "Description", "Item Sigs", "Item Signal", "Vendor", "Vendor name", "Lead Time", "Sourcing Responsible Code", "Sourcing Responsible Person", "Purchase Price", "Purchase Currency", "Planning Responsible Code", "Planning Responsible Name", "Stock", "Stock Value", "Estimated Cost Price"));
        dbColumns.addAll(Arrays.asList("item", "revision", "description", "item_sigs", "item_signal", "vendor", "vendor_name", "lead_time", "sourcing_responsible_code", "sourcing_responsible_person", "purchase_price", "purchase_currency", "planning_responsible_code", "planning_responsible_name", "stock", "stock_value", "estimated_cost_price"));
        log.debug((Object)("ReadEODataFromXLS for path: " + xlsFilePath));
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        ArrayList<Map<String, String>> data = P0045Tools.importDataFromXlsxFile(xlsFilePath, columns, 0);
        log.debug((Object)("Rows imported:" + data.size()));
        Session session = HibernateUtil.getSessionFactory().openSession();
        String sQuery = "";
        String deleteQuery = "DELETE FROM ".concat(tableName);
        log.debug((Object)deleteQuery);
        int count = 0;
        try {
            session.getTransaction().begin();
            session.createSQLQuery(deleteQuery).executeUpdate();
            log.debug((Object)"Table cleared...");
            for (Map<String, String> oneRow : data) {
                ++count;
                String item = oneRow.get("Item").trim();
                String revision = oneRow.get("Revision").trim();
                String desc = oneRow.get("Description").replace("'", "");
                String sigs = oneRow.get("Item Sigs");
                String signal = oneRow.get("Item Signal");
                String vendor = oneRow.get("Vendor");
                String vendor_name = oneRow.get("Vendor name");
                String lead_time = oneRow.get("Lead Time");
                String sourcing_resp_code = oneRow.get("Sourcing Responsible Code");
                String sourcing_resp_person = oneRow.get("Sourcing Responsible Person");
                String purchase_price = oneRow.get("Purchase Price");
                String purchase_curr = oneRow.get("Purchase Currency");
                String planning_resp_code = oneRow.get("Planning Responsible Code");
                String planning_resp_name = oneRow.get("Planning Responsible Name");
                String stock = oneRow.get("Stock");
                String stock_val = oneRow.get("Stock Value");
                String estimated_cost = oneRow.get("Estimated Cost Price");
                if (StringUtils.isBlank((CharSequence)stock)) {
                    stock = "0.0";
                    stock_val = "0.0";
                }
                sQuery = String.format("INSERT INTO " + tableName + "(item, revision, description,item_sigs,item_signal,vendor,vendor_name,lead_time,sourcing_responsible_code,sourcing_responsible_person, purchase_price,purchase_currency,planning_responsible_code,planning_responsible_name,stock,stock_value,estimated_cost_price) VALUES ('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')", item, revision, desc, sigs, signal, vendor, vendor_name, lead_time, sourcing_resp_code, sourcing_resp_person, purchase_price, purchase_curr, planning_resp_code, planning_resp_name, stock, stock_val, estimated_cost);
                if (count == 1) {
                    log.debug((Object)("INSERT QUERY: " + sQuery));
                }
                session.createSQLQuery(sQuery).executeUpdate();
            }
            session.getTransaction().commit();
            log.debug((Object)("Zaimportowano rekord\u00f3w: " + count));
        }
        catch (Exception ex) {
            log.error((Object)("Zapisyawnie danych nie powiod\u0142o si\u0119... obecny wiersz: " + count));
            log.error((Object)("ERROR QUERY: " + sQuery));
            log.error((Object)ex.getMessage(), (Throwable)ex);
            session.getTransaction().rollback();
        }
        finally {
            session.close();
        }
    }
}

