/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduledtasks;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;

@ScheduledTask
public class ImportDataFromXLSToTable {
    public static Logger log = Logger.getLogger(ImportDataFromXLSToTable.class);
    private static ArrayList<String> columns = new ArrayList();
    private static ArrayList<String> dbColumns = new ArrayList();

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("importDataFromXLSToTable")).name("Import danych do tabeli (konfiguracja)")).description("")).cancelable().parameter().id("xlsFilePath").name("\u015acie\u017cka do XLS").description("").type((Type)Types.STRING).create()).cancelable().parameter().id("fileColumns").name("Nazwy kolumn z pliku XLS").description("Rozdzielone przecinkiem").type((Type)Types.STRING).create()).parameter().id("tableName").name("Nazwa tabeli").description("").type((Type)Types.STRING).create()).parameter().id("tableColumns").name("Id kolumn z tabeli").description("Rozdzielone przecinkiem, w kolejno\u015bci odpowiadaj\u0105cej kolumnom z pliku XLS. Na tej podstawie zostanie wykonane mapowanie").type((Type)Types.STRING).create()).parameter().id("separator").name("Separator").description("").type((Type)Types.STRING).create()).parameter().id("removeItems").name("Czy usuwa\u0107 rekordy?").description("true/false").type((Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="xlsFilePath") String xlsFilePath, @Param(value="fileColumns") String fileColumns, @Param(value="tableName") String tableName, @Param(value="tableColumns") String tableColumns, @Param(value="separator") String separator, @Param(value="removeItems") String removeItems) {
        String[] columnsInFile = fileColumns.split(separator, -1);
        columns.addAll(Arrays.asList(columnsInFile));
        Object[] columnsInTable = tableColumns.split(separator, -1);
        dbColumns.addAll(Arrays.asList(columnsInTable));
        log.debug((Object)("ReadEODataFromXLS for path: " + xlsFilePath));
        ArrayList<Map<String, String>> data = P0045Tools.importDataFromXlsxFile(xlsFilePath, columns, 0);
        log.debug((Object)("Rows imported:" + data.size()));
        Session session = HibernateUtil.getSessionFactory().openSession();
        String sQuery = "";
        String deleteQuery = "DELETE FROM ".concat(tableName);
        int count = 0;
        try {
            session.getTransaction().begin();
            if (removeItems.equalsIgnoreCase("true")) {
                session.createSQLQuery(deleteQuery).executeUpdate();
                log.debug((Object)"Table cleared...");
            }
            for (Map<String, String> oneRow : data) {
                ++count;
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO ");
                sb.append(tableName);
                sb.append(" (");
                sb.append(StringUtils.join((Object[])columnsInTable, (String)","));
                sb.append(") VALUES(");
                for (int i = 0; i < columnsInFile.length; ++i) {
                    sb.append("'");
                    sb.append(StringEscapeUtils.escapeSql((String)oneRow.get(columnsInFile[i])));
                    if (i + 1 < columnsInFile.length) {
                        sb.append("',");
                        continue;
                    }
                    sb.append("'");
                }
                sb.append(")");
                sQuery = sb.toString();
                if (count == 1) {
                    log.debug((Object)("INSERT QUERY: " + sQuery));
                }
                session.createSQLQuery(sQuery).executeUpdate();
            }
            session.getTransaction().commit();
            log.debug((Object)("Zaimportowano rekord\u00f3w: " + count));
        }
        catch (Exception ex) {
            log.error((Object)("Import from XLS failed. Currently processed row: " + count));
            log.error((Object)("ERROR QUERY: " + sQuery));
            log.error((Object)ex.getMessage(), (Throwable)ex);
            session.getTransaction().rollback();
        }
        finally {
            session.close();
        }
    }
}

