/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduledtasks;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.util.MathFunctions;
import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

@ScheduledTask
public class GeneratePoForBusinessTrip {
    public static Logger log = Logger.getLogger(GeneratePoForBusinessTrip.class);

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("generatePoForBusinessTrip")).name("Generowanie PO dla procesu Business Trip")).description("")).cancelable().parameter().id("processDefId").name("Id definicji procesu").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING).create()).parameter().id("checkTaskId").name("Id zadania buforowego").description("").type((com.suncode.pwfl.core.type.Type)Types.STRING).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="processDefId") String processDefId, @Param(value="checkTaskId") String checkTaskId) {
        log.debug((Object)("GeneratePoForBusinessTrip for task: " + checkTaskId));
        ActivityFinder af = FinderFactory.getActivityFinder();
        ActivityService as = ServiceFactory.getActivityService();
        ProcessService ps = ServiceFactory.getProcessService();
        try {
            int prCount = 0;
            ArrayList<Activity> allTasksToCheck = P0045Tools.findOpenActivitiesForId(processDefId, checkTaskId);
            log.debug((Object)("Found " + allTasksToCheck.size() + " tasks at bufor step..."));
            for (Activity activity : allTasksToCheck) {
                log.debug((Object)("Verification of: " + activity.getActivityId()));
                try {
                    ArrayList<Map> onePartnerPoLines;
                    Map ctx = as.getActivityContext(activity.getProcessId(), activity.getActivityId());
                    String[] COL_IDS = new String[]{"type_of_cost", "cost_currency_booking", "cost_value", "cc_no_cost", "cc_holder_cost", "gl_account", "bp_name", "bp_no", "generate_po", "generated_prpo_no", "lp_etc", "approval_required", "comment_tab", "product_code_cost", "product_name_cost"};
                    List processTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)ctx, (String[])COL_IDS);
                    String[] bpNo = new String[processTable.size()];
                    int lineNo = 0;
                    HashMap businessPartnersPoLines = new HashMap();
                    for (Map oneLine : processTable) {
                        String businessPartner;
                        bpNo[lineNo] = businessPartner = (String)oneLine.get("bp_no");
                        String generate_po = (String)oneLine.get("generate_po");
                        String approval_required = (String)oneLine.get("approval_required");
                        String generated_prpo_no = (String)oneLine.get("generated_prpo_no");
                        String cost_type = (String)oneLine.get("type_of_cost");
                        oneLine.put("project_nr", "");
                        log.debug((Object)businessPartner);
                        if (!StringUtils.isBlank((String)businessPartner)) {
                            log.debug((Object)(generate_po + " | " + approval_required));
                            if (generate_po.trim().compareToIgnoreCase("yes") == 0 && StringUtils.isBlank((String)generated_prpo_no) && (approval_required.equalsIgnoreCase("Approved") || approval_required.matches("Yes.*higher"))) {
                                onePartnerPoLines = new ArrayList<Map>();
                                onePartnerPoLines.add(oneLine);
                                businessPartnersPoLines.put(lineNo, onePartnerPoLines);
                            }
                        }
                        ++lineNo;
                    }
                    String sProcessId = activity.getProcessId();
                    String generatedPrNo = "";
                    String lineId = "";
                    HashMap<String, String> linesToInsertNo = new HashMap<String, String>();
                    log.debug((Object)"Number of lines to generate: ".concat(String.valueOf(businessPartnersPoLines.size())));
                    String sDelegationNo = (String)ctx.get("business_travel_no");
                    Iterator iter = businessPartnersPoLines.entrySet().iterator();
                    while (iter.hasNext()) {
                        Integer key = (Integer)iter.next().getKey();
                        onePartnerPoLines = (ArrayList<Map>)businessPartnersPoLines.get(key);
                        try {
                            generatedPrNo = GeneratePoForBusinessTrip.generatePo(sProcessId, ctx, (List<Map<String, String>>)onePartnerPoLines);
                            ++prCount;
                            log.debug((Object)("Delegation: " + sDelegationNo + ", PR: " + generatedPrNo));
                            for (Map oneLine : onePartnerPoLines) {
                                lineId = (String)oneLine.get("lp_etc");
                                linesToInsertNo.put(lineId, generatedPrNo);
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    log.debug((Object)"Setting information about PR process...");
                    String[] lp_etc = ctx.get("lp_etc").toString().split(";", -1);
                    CharSequence[] generate_po = ctx.get("generate_po").toString().split(";", -1);
                    CharSequence[] generated_prpo_no = ctx.get("generated_prpo_no").toString().split(";", -1);
                    CharSequence[] approval_required = ctx.get("approval_required").toString().split(";", -1);
                    String[] cost_value = ctx.get("cost_value").toString().split(";", -1);
                    CharSequence[] approved_costs_value = ctx.get("approved_costs_value").toString().split(";", -1);
                    String[] cc_no_cost = ctx.get("cc_no_cost").toString().split(";", -1);
                    CharSequence[] cc_no_accepted_cost = ctx.get("cc_no_accepted_cost").toString().split(";", -1);
                    for (int i = 0; i < lp_etc.length; ++i) {
                        if (!linesToInsertNo.containsKey(lp_etc[i])) continue;
                        generate_po[i] = "";
                        generated_prpo_no[i] = (String)linesToInsertNo.get(lp_etc[i]);
                        approval_required[i] = "No";
                        approved_costs_value[i] = cost_value[i];
                        cc_no_accepted_cost[i] = cc_no_cost[i];
                    }
                    ctx.put("generate_po", String.join((CharSequence)";", generate_po));
                    ctx.put("generated_prpo_no", String.join((CharSequence)";", generated_prpo_no));
                    ctx.put("approval_required", String.join((CharSequence)";", approval_required));
                    ctx.put("approved_costs_value", String.join((CharSequence)";", approved_costs_value));
                    ctx.put("cc_no_accepted_cost", String.join((CharSequence)";", cc_no_accepted_cost));
                    ps.setProcessContext(activity.getProcessId(), ctx);
                    as.setActivityContext(activity.getProcessId(), activity.getActivityId(), ctx);
                    if (prCount <= 0) continue;
                    P0045Tools.acceptActivity(activity.getProcessId(), activity.getActivityId(), ctx, "approve");
                }
                catch (Exception e) {
                    log.error((Object)("Error for: " + activity.getActivityId()));
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            log.debug((Object)"GeneratePoForBusinessTrip finished.");
        }
    }

    private static String generatePo(String processId, Map<String, Object> processContext, List<Map<String, String>> poLines) throws Exception {
        log.debug((Object)"Started generating PO");
        HashMap<String, Object> poProcessContext = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String bp_number = poLines.get(0).get("bp_no");
        String cc_no = poLines.get(0).get("cc_no_cost");
        String cc_holder = poLines.get(0).get("cc_holder_cost");
        String[] bp_data = P0045Tools.getBpDataFromDb(bp_number);
        log.debug((Object)("Pobrano dane BP: " + bp_data[0] + ", " + bp_data[1] + ", " + bp_data[2]));
        poProcessContext.put("business_partner_name", bp_data[0]);
        poProcessContext.put("business_partner_no", bp_number);
        poProcessContext.put("nip", bp_data[1]);
        poProcessContext.put("address", bp_data[2]);
        poProcessContext.put("Initiator", (String)processContext.get("Initiator"));
        poProcessContext.put("cost_center", GeneratePoForBusinessTrip.getCCName(cc_no));
        poProcessContext.put("cost_center_no", cc_no);
        poProcessContext.put("department_manager", cc_holder);
        poProcessContext.put("dm_date", sdf.format(new Date()));
        poProcessContext.put("requestor", (String)processContext.get("Initiator"));
        poProcessContext.put("requestor_name", (String)processContext.get("requestor"));
        poProcessContext.put("details", "Business travel " + (String)processContext.get("business_travel_no"));
        poProcessContext.put("bt_process_id", processId);
        poProcessContext.put("origin", "BT");
        poProcessContext.put("origin_number", (String)processContext.get("business_travel_no"));
        int iMiesiac = Calendar.getInstance().get(2);
        int iRok = Calendar.getInstance().get(1);
        double total = 0.0;
        double total_pln = 0.0;
        String waluta = "PLN";
        boolean bApprovalRequired = false;
        String sApprovalRequired = "";
        ArrayList<String> tempWaluty = new ArrayList<String>();
        for (Map<String, String> oneLine : poLines) {
            String walutaLinii = oneLine.get("cost_currency_booking");
            if (tempWaluty.contains(walutaLinii)) continue;
            tempWaluty.add(walutaLinii);
        }
        if (tempWaluty.size() == 1) {
            waluta = (String)tempWaluty.get(0);
            for (Map<String, String> oneLine : poLines) {
                double dAmount = MathFunctions.round((double)Double.valueOf(oneLine.get("cost_value")), (int)2);
                total = MathFunctions.round((double)(total + dAmount), (int)2);
            }
            if (waluta.compareTo("PLN") == 0) {
                total_pln = total;
            }
        }
        for (Map<String, String> oneLine : poLines) {
            String gl_account = oneLine.get("gl_account");
            String col_company = (String)processContext.get("company");
            String[] glData = P0045Tools.getGlDataByNumberForPO(gl_account, col_company);
            oneLine.put("qty", "1.0");
            oneLine.put("gl_name", glData[0]);
            oneLine.put("gl_type_of_cost", glData[1]);
            oneLine.put("descrip", (String)processContext.get("business_travel_no") + " " + oneLine.get("type_of_cost"));
            oneLine.put("project_nr", "");
            sApprovalRequired = oneLine.get("approval_required");
            if (sApprovalRequired.indexOf("Yes") <= -1) continue;
            bApprovalRequired = true;
        }
        if (bApprovalRequired) {
            poProcessContext.put("prpo_status", "Skip to waiting and approval");
        } else {
            poProcessContext.put("prpo_status", "Skip to waiting");
        }
        String[] NEW_COL_IDS = new String[]{"type_of_cost", "cost_currency_booking", "cost_value", "gl_account", "bp_name", "bp_no", "qty", "gl_name", "gl_type_of_cost", "descrip", "product_code_cost", "product_name_cost", "project_nr", "comment_tab"};
        Map poTableContext = DynamicTableFunctions.convertFromListOfMapsToMap(poLines, (String[])NEW_COL_IDS);
        poProcessContext.put("currency", waluta);
        poProcessContext.put("total", total);
        poProcessContext.put("pr_total_value_in_pln", total_pln);
        poProcessContext.put("total_in_pln", total_pln);
        log.debug((Object)"Total in PLN: ".concat(String.valueOf(total_pln)));
        log.debug((Object)"Lines in PLN: ".concat((String)poTableContext.get("cost_value")));
        poProcessContext.put("descrip", (String)poTableContext.get("descrip"));
        poProcessContext.put("product_name", (String)poTableContext.get("product_name_cost"));
        poProcessContext.put("product_code", (String)poTableContext.get("product_code_cost"));
        poProcessContext.put("project_nr", (String)poTableContext.get("project_nr"));
        poProcessContext.put("type_of_cost", (String)poTableContext.get("gl_type_of_cost"));
        poProcessContext.put("gl_account", (String)poTableContext.get("gl_account"));
        poProcessContext.put("gl_descr", (String)poTableContext.get("gl_name"));
        poProcessContext.put("qty", (String)poTableContext.get("qty"));
        poProcessContext.put("received_qty", (String)poTableContext.get("qty"));
        poProcessContext.put("unit_net_price", (String)poTableContext.get("cost_value"));
        poProcessContext.put("total_value", (String)poTableContext.get("cost_value"));
        poProcessContext.put("comments", (String)poTableContext.get("comment_tab"));
        log.debug((Object)"PO data ready to generate...");
        String createdPrNo = P0045Tools.createPrProcess(poProcessContext);
        log.debug((Object)("PO generated: " + createdPrNo));
        return createdPrNo;
    }

    public static String getCCName(String ccNo) {
        String ccName = "";
        SQLBuilder builder = new SQLBuilder();
        SQLFinder finder = FinderFactory.getSQLFinder();
        builder.setQuery("SELECT descr FROM pm_cust_cost_centers");
        builder.addScalar("descr", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("cost_center", (Object)ccNo, FilterOperator.EQ));
        builder.addFilter((SQLFilter)new SimpleSQLFilter("status", (Object)"active", FilterOperator.EQ));
        List allRec = finder.find(builder);
        if (allRec.size() > 0) {
            ccName = (String)((Map)allRec.get(0)).get("descr");
        }
        return ccName;
    }
}

