/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pr;

import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.categories.Categories;
import com.suncode.plugin.pr.PR_BudgetTools;
import com.suncode.plugin.pr.PR_PurchaseTable;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@VariableSetter
public class PR_SkipAcceptation {
    public static Logger log = Logger.getLogger(PR_SkipAcceptation.class);

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("pr-skip-acceptation")).name("PR - Skip acceptation")).description("PR - Skip acceptation")).category(new Category[]{Categories.CARGOTEC})).parameter().id("acceptancePath").name("Acceptance path").description("").type((Type)Types.STRING).create()).parameter().id("costCenter").name("Cost Center No").description("").type((Type)Types.STRING).create()).parameter().id("userName").name("User name").description("").type((Type)Types.STRING).create()).parameter().id("processId").name("Process Id").description("").type((Type)Types.STRING).create()).parameter().id("activityId").name("Activity Id").description("").type((Type)Types.STRING).create()).parameter().id("departmentManager").name("Dep. Manager").description("").type((Type)Types.STRING).create()).parameter().id("glAccount").name("GL account").description("tab").type((Type)Types.STRING_ARRAY).create()).parameter().id("glDescr").name("GL descr").description("tab").type((Type)Types.STRING_ARRAY).create()).parameter().id("totalValue").name("Total value").description("tab").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("currency").name("Currency").description("").type((Type)Types.STRING).create()).parameter().id("typeOfPurchase").name("Type of purchase").description("").type((Type)Types.STRING).create()).parameter().id("totalInPln").name("Total in PLN").description("").type((Type)Types.FLOAT).create()).parameter().id("budget").name("Budget").description("").type((Type)Types.VARIABLE).create()).parameter().id("action").name("Action").description("").type((Type)Types.VARIABLE).create();
    }

    public void set(@Param String acceptancePath, @Param String costCenter, @Param String userName, @Param String processId, @Param String activityId, @Param String departmentManager, @Param String[] glAccount, @Param String[] glDescr, @Param Float[] totalValue, @Param String currency, @Param String typeOfPurchase, @Param Float totalInPln, @Param Variable budget, @Param Variable action) {
        String roles = P0045Tools.PR_checkUserAcceptationRoles(activityId, userName, acceptancePath, costCenter);
        String sActivityId = activityId;
        String[] sRoles = roles.split(";", -1);
        try {
            String sDepManager = departmentManager;
            sRoles[0] = userName.equalsIgnoreCase(sDepManager) ? "true" : "false";
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        String sLevel = "skip0";
        log.debug((Object)(sActivityId + " | " + sLevel));
        if ((sActivityId.indexOf("purchase_request") > 0 || sActivityId.indexOf("purchase_rejected") > 0) && sRoles[0].equalsIgnoreCase("true")) {
            sLevel = sRoles[1].equalsIgnoreCase("true") && sRoles[2].equalsIgnoreCase("true") && sRoles[3].equalsIgnoreCase("true") ? "skip4" : (sRoles[1].equalsIgnoreCase("true") && sRoles[2].equalsIgnoreCase("true") ? "skip3" : (sRoles[1].equalsIgnoreCase("true") ? "skip2" : "skip1"));
        } else if (sActivityId.indexOf("acceptance_dm") > 0 && sRoles[1].equalsIgnoreCase("true")) {
            sLevel = sRoles[2].equalsIgnoreCase("true") && sRoles[3].equalsIgnoreCase("true") ? "skip4" : (sRoles[2].equalsIgnoreCase("true") ? "skip3" : "skip2");
        } else if (sActivityId.endsWith("acceptance_fc")) {
            log.debug((Object)sRoles[3]);
            sLevel = sRoles[3].equalsIgnoreCase("true") ? "skip4" : "skip3";
        } else if (sActivityId.indexOf("acceptance_fcm") > 0 && sRoles[3].equalsIgnoreCase("true")) {
            sLevel = "skip4";
        }
        if (typeOfPurchase.equalsIgnoreCase("Cost")) {
            typeOfPurchase = "cost";
        }
        if (typeOfPurchase.equalsIgnoreCase("Fixed Asset")) {
            typeOfPurchase = "investment";
        }
        String sBudgetState = PR_SkipAcceptation.PR_CheckBudgetInfo(costCenter, P0045Tools.joinTableValues(glAccount), P0045Tools.joinTableValues(glDescr), P0045Tools.joinTableValues(totalValue), currency, typeOfPurchase, processId);
        budget.setValue((Object)sBudgetState);
        Float nValueLimit = Float.valueOf(0.0f);
        if (typeOfPurchase.equalsIgnoreCase("Cost") && sBudgetState.equalsIgnoreCase("In line with budget")) {
            if (sLevel.equalsIgnoreCase("skip2")) {
                nValueLimit = Float.valueOf(10000.0f);
            }
            if (sLevel.equalsIgnoreCase("skip3")) {
                nValueLimit = Float.valueOf(40000.0f);
            }
        }
        if (typeOfPurchase.equalsIgnoreCase("Cost") && sBudgetState.equalsIgnoreCase("Over budget") && sLevel.equalsIgnoreCase("skip3")) {
            nValueLimit = Float.valueOf(40000.0f);
        }
        if (totalInPln.floatValue() < nValueLimit.floatValue()) {
            sLevel = "skip4";
        }
        if (!sLevel.equalsIgnoreCase("skip0")) {
            action.setValue((Object)sLevel);
        } else if (activityId.indexOf("purchase_request") > -1) {
            action.setValue((Object)"send");
        } else if (activityId.indexOf("acceptance_dm") > -1) {
            action.setValue((Object)"approve");
        } else {
            action.setValue((Object)sLevel);
        }
    }

    private static String PR_CheckBudgetInfo(String sCostCenter, String sGl, String sGlDesc, String sValue, String sCurrency, String sType, String sProcessId) {
        log.debug((Object)"PR_CheckBudgetInfo");
        String sBudgetState = "";
        ArrayList<PR_PurchaseTable> alGls = PR_BudgetTools.getDistinctGls(sGl, sGlDesc, sValue);
        try {
            for (int i = 0; i < alGls.size(); ++i) {
                HashMap<String, String> hmOneRow;
                if (StringUtils.isBlank((String)sCostCenter) || (sBudgetState = (hmOneRow = PR_BudgetTools.checkBudgetForOneRow(alGls.get(i), sCostCenter, sType, sCurrency, sProcessId)).get("budget_state")).compareTo("Over Budget") != 0) continue;
                i = alGls.size();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sBudgetState;
    }
}

