/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pr;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.util.MathFunctions;
import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.XMLTools;
import com.suncode.plugin.categories.Categories;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Application
public class PR_CreatePrFromOTM {
    public static Logger log = Logger.getLogger(PR_CreatePrFromOTM.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("prCreatePrFromOtm")).name("Create PR from OTM")).icon((Icon)SilkIconPack.APPLICATION_CASCADE)).description("")).category(new Category[]{Categories.CARGOTEC});
    }

    public void execute(ActivityContextMap activityCtxMap) {
        try {
            String[] distinctCC;
            Map ctx = activityCtxMap.getVariables();
            String workflow_id = (String)((Variable)ctx.get("workflow_id")).getValue();
            String otmInvoiceId = (String)((Variable)ctx.get("otm_invoice_id")).getValue();
            String otmVoucherId = (String)((Variable)ctx.get("otm_voucher_id")).getValue();
            String otmDomainName = (String)((Variable)ctx.get("otm_domain_name")).getValue();
            String correctingInvoice = (String)((Variable)ctx.get("correcting_invoice")).getValue();
            log.debug((Object)("PR_CreatePrFromOTM for id: " + otmInvoiceId));
            DocumentService ds = ServiceFactory.getDocumentService();
            DocumentFinder df = FinderFactory.getDocumentFinder();
            ActivityFinder af = FinderFactory.getActivityFinder();
            List docs = df.getDocumentsFromProcess(activityCtxMap.getProcessId(), new String[0]);
            String bp_number = (String)((Variable)ctx.get("business_partner_no")).getValue();
            String[] bp_data = P0045Tools.getBpDataFromDb(bp_number);
            log.debug((Object)("Pobrano dane BP: " + bp_data[0] + ", " + bp_data[1] + ", " + bp_data[2]));
            String currency = (String)((Variable)ctx.get("currency")).getValue();
            String cc_no = (String)((Variable)ctx.get("cost_center")).getValue();
            String gl = (String)((Variable)ctx.get("gl_account")).getValue();
            String descr = (String)((Variable)ctx.get("description")).getValue();
            String cost_type = (String)((Variable)ctx.get("cost_type")).getValue();
            String product_code = (String)((Variable)ctx.get("product_code")).getValue();
            String project_no = (String)((Variable)ctx.get("project_number")).getValue();
            String net_price = (String)((Variable)ctx.get("net_price")).getValue();
            String quantity = (String)((Variable)ctx.get("quantity")).getValue();
            String total_value = (String)((Variable)ctx.get("total_value")).getValue();
            String[] tCCno = cc_no.split(";", -1);
            String[] tGl = gl.split(";", -1);
            String[] tDescr = descr.split(";", -1);
            String[] tCostType = cost_type.split(";", -1);
            String[] tProductCode = product_code.split(";", -1);
            String[] tProjectNo = project_no.split(";", -1);
            String[] tNetPrice = net_price.split(";", -1);
            String[] tQuantity = quantity.split(";", -1);
            String[] tTotalValue = total_value.split(";", -1);
            String[] COL_IDS = new String[]{"cost_currency_booking", "total_value", "gl_account", "qty", "net_price", "gl_name", "gl_type_of_cost", "descrip", "product_code_cost", "product_name_cost", "project_nr"};
            HashMap<String, Object> poProcessContext = new HashMap<String, Object>();
            poProcessContext.put("business_partner_name", bp_data[0]);
            poProcessContext.put("business_partner_no", bp_number);
            poProcessContext.put("nip", bp_data[1]);
            poProcessContext.put("address", bp_data[2]);
            poProcessContext.put("Initiator", "admin");
            poProcessContext.put("dm_date", sdf.format(new Date()));
            Set<User> users = P0045Tools.getUserFromGroup("OTM Requestors");
            poProcessContext.put("requestor", "TMS Invoice");
            poProcessContext.put("requestor_name", "TMS Invoice");
            poProcessContext.put("origin", "TMS");
            poProcessContext.put("origin_number", otmInvoiceId);
            poProcessContext.put("origin_pr_value", ((Variable)ctx.get("net_value")).getValue());
            poProcessContext.put("invoice_number", ((Variable)ctx.get("invoice_no")).getValue());
            poProcessContext.put("details", "PO generated for invoice");
            for (String cc : distinctCC = (String[])Arrays.stream(tCCno).distinct().toArray(String[]::new)) {
                poProcessContext.put("cost_center", P0045Tools.getCCName(cc));
                poProcessContext.put("cost_center_no", cc);
                poProcessContext.put("department_manager", P0045Tools.getCCHolder(cc));
                ArrayList prLines = new ArrayList();
                for (int i = 0; i < tCCno.length; ++i) {
                    if (!cc.equalsIgnoreCase(tCCno[i])) continue;
                    HashMap<String, String> prLine = new HashMap<String, String>();
                    prLine.put("cost_currency_booking", currency);
                    prLine.put("gl_account", tGl[i]);
                    String[] glData = P0045Tools.getGlDataByNumber(tGl[i]);
                    prLine.put("gl_name", glData[0]);
                    prLine.put("gl_type_of_cost", glData[1]);
                    prLine.put("descrip", tDescr[i]);
                    prLine.put("product_code_cost", tProductCode[i]);
                    prLine.put("product_name_cost", P0045Tools.getProductName(tProductCode[i]));
                    prLine.put("project_nr", tProjectNo[i]);
                    prLine.put("qty", tQuantity[i]);
                    prLine.put("net_price", tNetPrice[i]);
                    prLine.put("total_value", tTotalValue[i]);
                    prLines.add(prLine);
                    log.debug(prLine);
                }
                int iMiesiac = Calendar.getInstance().get(2);
                int iRok = Calendar.getInstance().get(1);
                double total = 0.0;
                double total_pln = 0.0;
                String waluta = "PLN";
                boolean bApprovalRequired = false;
                String sApprovalRequired = "";
                ArrayList<String> tempCurrency = new ArrayList<String>();
                for (Map map : prLines) {
                    String line_currency = (String)map.get("cost_currency_booking");
                    if (tempCurrency.contains(line_currency)) continue;
                    tempCurrency.add(line_currency);
                }
                if (tempCurrency.size() == 1) {
                    waluta = (String)tempCurrency.get(0);
                    for (Map map : prLines) {
                        double dAmount = MathFunctions.round((double)Double.valueOf((String)map.get("total_value")), (int)2);
                        total = MathFunctions.round((double)(total + dAmount), (int)2);
                    }
                    if (waluta.compareTo("PLN") == 0) {
                        total_pln = total;
                    } else {
                        SimpleDateFormat workflowDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = new Date();
                        String sCurrentDate = workflowDateFormat.format(date);
                        sRate = Double.toString(P0045Tools.getCurrencyRateFromNbp(waluta, sCurrentDate));
                        double dRate = 0.0;
                        if (!StringUtils.isBlank((String)sRate)) {
                            dRate = Double.parseDouble(sRate);
                            log.debug((Object)(total + " * " + dRate));
                            total_pln = MathFunctions.round((double)(total * dRate), (int)2);
                        }
                    }
                } else {
                    for (Map map : prLines) {
                        String walutaLinii = (String)map.get("cost_currency_booking");
                        sRate = P0045Tools.getExchangeRate(walutaLinii, iMiesiac, iRok);
                        String sRatePLN = P0045Tools.getExchangeRate("PLN", iMiesiac, iRok);
                        double dRate = 0.0;
                        double dRatePLN = 0.0;
                        double dAmount = MathFunctions.round((double)Double.valueOf((String)map.get("total_value")), (int)2);
                        double dAmountInPLN = 0.0;
                        if (!StringUtils.isBlank((String)sRate) && !StringUtils.isBlank((String)sRatePLN)) {
                            dRate = Double.parseDouble(sRate);
                            dRatePLN = Double.parseDouble(sRatePLN);
                            dAmountInPLN = dAmount / dRate * dRatePLN;
                        }
                        total = MathFunctions.round((double)(total + dAmountInPLN), (int)2);
                        map.put("total_value", String.valueOf(dAmountInPLN));
                    }
                    log.debug((Object)total);
                    log.debug((Object)total_pln);
                    total_pln = total;
                }
                Map poTableContext = DynamicTableFunctions.convertFromListOfMapsToMap(prLines, (String[])COL_IDS);
                poProcessContext.put("currency", currency);
                poProcessContext.put("total", total);
                poProcessContext.put("pr_total_value_in_pln", total_pln);
                poProcessContext.put("total_in_pln", total_pln);
                log.debug((Object)"Total in PLN: ".concat(String.valueOf(total_pln)));
                log.debug((Object)"Lines in PLN: ".concat((String)poTableContext.get("total_value")));
                poProcessContext.put("descrip", (String)poTableContext.get("descrip"));
                poProcessContext.put("product_name", (String)poTableContext.get("product_name_cost"));
                poProcessContext.put("product_code", (String)poTableContext.get("product_code_cost"));
                poProcessContext.put("project_nr", (String)poTableContext.get("project_nr"));
                poProcessContext.put("type_of_cost", (String)poTableContext.get("gl_type_of_cost"));
                poProcessContext.put("gl_account", (String)poTableContext.get("gl_account"));
                poProcessContext.put("gl_descr", (String)poTableContext.get("gl_name"));
                poProcessContext.put("qty", (String)poTableContext.get("qty"));
                poProcessContext.put("total_received_qty", (String)poTableContext.get("qty"));
                poProcessContext.put("unit_net_price", (String)poTableContext.get("net_price"));
                poProcessContext.put("total_value", (String)poTableContext.get("total_value"));
                log.debug((Object)("PR data ready to generate for CC " + cc));
                String string = P0045Tools.createPrProcessReturnId(poProcessContext);
                log.debug((Object)("PR generated: " + string));
                List tasks = af.findOpenedActivities(string);
                for (WfDocument doc : docs) {
                    for (Activity task : tasks) {
                        ds.attachDocumentToProcess(doc, "admin", string, task.getActivityId());
                    }
                }
            }
            String filePath = SystemProperties.getString((String)"OTM_EXPORT_FILE_PATH");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("otm_invoice_id", otmInvoiceId);
            data.put("otm_voucher_id", otmVoucherId);
            data.put("otm_domain_name", otmDomainName);
            data.put("workflow_invoice_id", activityCtxMap.getProcessId());
            data.put("import_status", "OK");
            data.put("approval_status", "");
            data.put("error_log", "");
            XMLTools.generateOTMResponse(filePath, data);
            log.debug((Object)"PR_CreatePrFromOTM finished.");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

