/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.suncode.plugin.P0045Tools;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

@ScheduledTask
public class ReadEODataFromXLS {
    public static Logger log = Logger.getLogger(ReadEODataFromXLS.class);
    private static ArrayList<String> columns = new ArrayList();
    private static String _separator = ";";
    private static String _setDateClasses = "A,B,C";

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("readEODataFromXLS")).name("Odczyt danych EO i akceptacja procesu")).description("Odczyt danych EO i akceptacja procesu")).cancelable().parameter().id("xlsFilePath").name("\u015acie\u017cka do XLS").description("\u015acie\u017cka do XLS").type((com.suncode.pwfl.core.type.Type)Types.STRING).create();
    }

    public void execute(@Param(value="xlsFilePath") String xlsFilePath) {
        boolean toApprove = true;
        boolean sendBack = false;
        Object sError = "";
        ProgressHolder ph = new ProgressHolder();
        ph.setProgress(Double.valueOf(0.01));
        columns.addAll(Arrays.asList("Item", "Description", "Item Sigs", "Item Signal", "Vendor", "Vendor name", "Lead Time", "Sourcing Responsible Code", "Sourcing Responsible Person", "Purchase Price", "Purchase Currency", "Planning Responsible Code", "Planning Responsible Name", "Stock", "Stock Value"));
        log.debug((Object)("ReadEODataFromXLS for path: " + xlsFilePath));
        ArrayList<Map<String, String>> data = P0045Tools.importDataFromItemTable(columns);
        log.debug((Object)("Rows imported:" + data.size()));
        ph.setProgress(Double.valueOf(0.25));
        log.debug((Object)"Searching for task to be updated");
        ArrayList<Object> allTasksToUpdate = new ArrayList();
        ProcessFinder pf = FinderFactory.getProcessFinder();
        ProcessService ps = ServiceFactory.getProcessService();
        ActivityService as = ServiceFactory.getActivityService();
        UserService us = ServiceFactory.getUserService();
        UserFinder uf = FinderFactory.getUserFinder();
        allTasksToUpdate = P0045Tools.findOpenActivitiesForId("eo", "oczekiwanie_na_dane_eo");
        Map<String, Object> activityCtx = new HashMap();
        ph.setProgress(Double.valueOf(0.5));
        for (Activity activity : allTasksToUpdate) {
            toApprove = true;
            sendBack = false;
            activityCtx = as.getActivityContext(activity.getProcessId(), activity.getActivityId());
            String[] item_no = ((String)activityCtx.get("new_item_no")).split(";", -1);
            String[] belongs_to = ((String)activityCtx.get("belongs_to")).split(";", -1);
            String[] type_of_purchase = ((String)activityCtx.get("type_of_purchase")).split(";", -1);
            String[] new_item = ((String)activityCtx.get("new_item")).split(";", -1);
            String[] material_planner_needed = ((String)activityCtx.get("material_planner_needed")).split(";", -1);
            StringBuilder sigs = new StringBuilder();
            StringBuilder vendor_no = new StringBuilder();
            StringBuilder vendor_name = new StringBuilder();
            StringBuilder logistic_administrator = new StringBuilder();
            StringBuilder responsible_sourcing = new StringBuilder();
            StringBuilder responsible_sourcing_name = new StringBuilder();
            StringBuilder responsible_logistics = new StringBuilder();
            StringBuilder responsible_logistics_name = new StringBuilder();
            StringBuilder stock_in_mau = new StringBuilder();
            StringBuilder stock_value_in_mau = new StringBuilder();
            StringBuilder lead_time = new StringBuilder();
            String sourcingCode = "";
            String logisticsCode = "";
            int count = 0;
            String errorItem = "";
            for (String item : item_no) {
                log.debug((Object)("Process: " + activity.getProcessId() + ", item: " + item));
                Map oneResult = new HashMap();
                if (type_of_purchase[count].compareTo("Manufactured") == 0) {
                    ++count;
                    sigs.append("").append(_separator);
                    vendor_no.append("").append(_separator);
                    vendor_name.append("").append(_separator);
                    stock_in_mau.append("0.0").append(_separator);
                    stock_value_in_mau.append("0.0").append(_separator);
                    lead_time.append("").append(_separator);
                    responsible_sourcing.append("").append(_separator);
                    responsible_sourcing_name.append("").append(_separator);
                    responsible_logistics.append("").append(_separator);
                    responsible_logistics_name.append("").append(_separator);
                    continue;
                }
                String belongs_to_item = belongs_to[count];
                try {
                    log.debug((Object)("XLS DATA READ FOR: " + item + " | " + belongs_to_item));
                    oneResult = StringUtils.isBlank((CharSequence)belongs_to_item) ? (Map)data.stream().filter(oneMap -> item.toLowerCase().equals(((String)oneMap.get("Item")).trim().toLowerCase())).findFirst().orElse(null) : (Map)data.stream().filter(oneMap -> belongs_to_item.equals(((String)oneMap.get("Item")).trim())).findFirst().orElse(null);
                    for (Map.Entry entry : oneResult.entrySet()) {
                        log.debug((Object)((String)entry.getKey() + " | " + (String)entry.getValue()));
                    }
                }
                catch (NullPointerException e) {
                    log.debug((Object)("Item " + item + " not found in XLS data..."));
                    if (type_of_purchase[count].contains("Purchase") && new_item[count].compareTo("No") == 0) {
                        sendBack = true;
                        sError = "EO REQUEST: Error during item " + item + " verification. Please check all items configuration in LN system.";
                    } else {
                        toApprove = false;
                    }
                    sigs.append("").append(_separator);
                    vendor_no.append("").append(_separator);
                    vendor_name.append("").append(_separator);
                    stock_in_mau.append("").append(_separator);
                    stock_value_in_mau.append("").append(_separator);
                    lead_time.append("").append(_separator);
                    responsible_sourcing.append("").append(_separator);
                    responsible_sourcing_name.append("").append(_separator);
                    responsible_logistics.append("").append(_separator);
                    responsible_logistics_name.append("").append(_separator);
                    break;
                }
                sigs.append((String)oneResult.get("Item Sigs")).append(_separator);
                vendor_no.append((String)oneResult.get("Vendor")).append(_separator);
                vendor_name.append((String)oneResult.get("Vendor name")).append(_separator);
                stock_in_mau.append((String)oneResult.get("Stock")).append(_separator);
                stock_value_in_mau.append((String)oneResult.get("Stock Value")).append(_separator);
                lead_time.append((String)oneResult.get("Lead Time")).append(_separator);
                sourcingCode = (String)oneResult.get("Sourcing Responsible Code");
                logisticsCode = (String)oneResult.get("Planning Responsible Code");
                if (StringUtils.isBlank((CharSequence)sourcingCode) || sourcingCode.compareTo("B00010") == 0) {
                    sourcingCode = P0045Tools.getDefaultSourcingResponsible();
                }
                if (StringUtils.isBlank((CharSequence)logisticsCode)) {
                    logisticsCode = "X";
                }
                User sourcingUser = (User)uf.findOneByProperty("number", (Object)sourcingCode, new String[0]);
                User logisticsUser = (User)uf.findOneByProperty("number", (Object)logisticsCode, new String[0]);
                if (sourcingUser == null) {
                    sourcingCode = P0045Tools.getDefaultSourcingResponsible();
                    sourcingUser = (User)uf.findOneByProperty("number", (Object)sourcingCode, new String[0]);
                }
                responsible_sourcing.append(sourcingUser.getUserName()).append(_separator);
                responsible_sourcing_name.append(sourcingUser.getFullName()).append(_separator);
                if (logisticsUser != null) {
                    responsible_logistics.append(logisticsUser.getUserName()).append(_separator);
                    responsible_logistics_name.append(logisticsUser.getFullName()).append(_separator);
                } else if (new_item[count].compareTo("No") == 0) {
                    log.debug((Object)("No logistics user for code: " + logisticsCode));
                    responsible_logistics.append("").append(_separator);
                    responsible_logistics_name.append("").append(_separator);
                    sendBack = true;
                    errorItem = StringUtils.isBlank((CharSequence)belongs_to_item) ? errorItem.concat(item).concat(", ") : errorItem.concat(belongs_to_item).concat(" (Belongs to), ");
                    sError = "For items " + errorItem + "it was not possible to find material planner.";
                } else {
                    responsible_logistics.append("").append(_separator);
                    responsible_logistics_name.append("").append(_separator);
                }
                ++count;
            }
            activityCtx.put("sigs", P0045Tools.removeLastChar(sigs.toString()));
            activityCtx.put("vendor_no", P0045Tools.removeLastChar(vendor_no.toString()));
            activityCtx.put("vendor_name", P0045Tools.removeLastChar(vendor_name.toString()));
            activityCtx.put("logistic_administrator", P0045Tools.removeLastChar(logistic_administrator.toString()));
            String stock_in_mau_temp = stock_in_mau.toString();
            stock_in_mau_temp = stock_in_mau_temp.replace(",", "");
            stock_in_mau_temp = stock_in_mau_temp.replace("null", "0.0");
            activityCtx.put("stock_in_mau", P0045Tools.removeLastChar(stock_in_mau_temp));
            String stock_value_in_mau_temp = stock_value_in_mau.toString();
            stock_value_in_mau_temp = stock_value_in_mau_temp.replace(",", "");
            log.debug((Object)("stock_value_in_mau: " + stock_value_in_mau_temp));
            activityCtx.put("stock_value_in_mau", P0045Tools.removeLastChar(stock_value_in_mau_temp));
            activityCtx.put("lead_time", P0045Tools.removeLastChar(lead_time.toString()));
            activityCtx.put("responsible_sourcing_login", P0045Tools.removeLastChar(responsible_sourcing.toString()));
            activityCtx.put("responsible_sourcing", P0045Tools.removeLastChar(responsible_sourcing_name.toString()));
            activityCtx.put("responsible_logistics_login", P0045Tools.removeLastChar(responsible_logistics.toString()));
            activityCtx.put("responsible_logistics", P0045Tools.removeLastChar(responsible_logistics_name.toString()));
            SQLFinder finder = FinderFactory.getSQLFinder();
            SQLBuilder builder = new SQLBuilder();
            String product_line = (String)activityCtx.get("product_line");
            String sQuery = "SELECT col_administrator FROM pm_cust_product_lines";
            builder.setQuery(sQuery);
            builder.addScalar("col_administrator", (Type)StandardBasicTypes.STRING);
            SimpleSQLFilter filter = new SimpleSQLFilter("col_product_line", (Object)product_line, FilterOperator.EQ);
            builder.addFilter((SQLFilter)filter);
            log.debug((Object)("sQuery: " + sQuery));
            List col_adm_data = finder.find(builder);
            log.debug((Object)("col_adm_data: " + col_adm_data.size()));
            Map oneRec = null;
            String sColAdm = "";
            if (col_adm_data.size() > 0) {
                oneRec = (Map)col_adm_data.get(0);
                sColAdm = (String)oneRec.get("col_administrator");
            }
            activityCtx.put("logistic_administrator", sColAdm);
            ps.setProcessContext(activity.getProcessId(), activityCtx);
            as.setActivityContext(activity.getProcessId(), activity.getActivityId(), activityCtx);
            boolean bSetDates = false;
            String sEoClass = (String)activityCtx.get("eo_class");
            if (_setDateClasses.contains(sEoClass)) {
                bSetDates = true;
            }
            String sNewItem = activityCtx.get("new_item").toString();
            String sNewRevision = activityCtx.get("sourcing_needed").toString();
            String sPPNeeded = activityCtx.get("pp_needed").toString();
            log.debug((Object)(sNewItem + "\n" + sNewRevision + "\n" + sPPNeeded));
            log.debug((Object)(sNewItem.indexOf("Yes") + "\n" + sNewRevision.indexOf("Yes") + "\n" + sPPNeeded.indexOf("No")));
            if (sNewItem.indexOf("Yes") <= -1 && sNewRevision.indexOf("Yes") <= -1 && sPPNeeded.indexOf("Yes") > -1) {
                bSetDates = false;
            }
            if (toApprove && bSetDates && !sendBack) {
                log.debug((Object)"Approving with set_date");
                activityCtx.put("akcja_date", "set_date");
                activityCtx.put("akcja", "set_date");
                P0045Tools.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityCtx, "set_date");
                continue;
            }
            if (toApprove && sendBack) {
                log.debug((Object)"Sending back");
                activityCtx.put("akcja", "send_back");
                CommentService cs = ServiceFactory.getCommentService();
                Date dDate = new Date();
                Long lTime = dDate.getTime();
                Comment comment = new Comment();
                comment.setProcessId(activity.getProcessId());
                comment.setActivityId(activity.getActivityId());
                comment.setUserId("admin");
                comment.setComment((String)sError);
                comment.setTimestamp(lTime);
                cs.createComment(comment);
                P0045Tools.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityCtx, "send_back");
                continue;
            }
            if (toApprove) {
                log.debug((Object)"Approving without set_date");
                activityCtx.put("akcja", "accept");
                P0045Tools.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityCtx, "accept");
                continue;
            }
            log.debug((Object)"Task waiting for next XLS verification...");
        }
        ph.setProgress(Double.valueOf(1.0));
    }
}

