/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.plusmpm.util.Tools;
import com.plusmpm.util.virtualtables.Record;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VRecord;
import com.plusmpm.util.virtualtables.VTable;
import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.eo.DynamicTableColumns;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class P0045eoSourcingAssignments {
    public static Logger log = Logger.getLogger(P0045eoSourcingAssignments.class);

    public static void setSourcingAssignments(Map<String, Object> processContext) throws Exception {
        log.trace((Object)"*************** eo.P0045eoLogisticAssignments ********");
        String[] COL_IDS = DynamicTableColumns.getColumns();
        UserService us = ServiceFactory.getUserService();
        String product_line = (String)processContext.get("product_line");
        String sourcingInvolved = "";
        String sourcingAdministrator = "";
        ArrayList<String> listSourcingInvolved = new ArrayList<String>();
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        String sQuery = "SELECT col_sourcing_involved, col_sourcing_administrator FROM pm_cust_product_lines";
        builder.setQuery(sQuery);
        builder.addScalar("col_sourcing_involved", (Type)StandardBasicTypes.STRING);
        builder.addScalar("col_administrator", (Type)StandardBasicTypes.STRING);
        builder.addFilter((SQLFilter)new SimpleSQLFilter("col_product_line", (Object)product_line, FilterOperator.EQ));
        log.debug((Object)("sQuery: " + sQuery));
        List data = finder.find(builder);
        for (Map rec : data) {
            String[] arraySourcingInvolved;
            Object sourcingAdministratorName = "";
            sourcingInvolved = (String)rec.get("col_sourcing_involved");
            sourcingAdministrator = (String)rec.get("col_sourcing_administrator");
            if (sourcingAdministrator != null) {
                log.debug((Object)("sourcingAdministrator" + sourcingAdministrator));
            } else {
                log.debug((Object)"sourcingAdministrator is null");
            }
            String[] tabsourcingAdministrator = sourcingAdministrator.split(",", -1);
            for (String item : tabsourcingAdministrator) {
                User userForSA = us.getUser(item, new String[0]);
                String userName = "";
                if (userForSA != null) {
                    userName = userForSA.getFullName();
                }
                sourcingAdministratorName = (String)sourcingAdministratorName + userName + ",";
            }
            if (((String)sourcingAdministratorName).length() > 0) {
                sourcingAdministratorName = ((String)sourcingAdministratorName).substring(0, ((String)sourcingAdministratorName).length() - 1);
            }
            if (sourcingAdministratorName != null) {
                log.debug((Object)("sourcingAdministratorName" + (String)sourcingAdministratorName));
            } else {
                log.debug((Object)"sourcingAdministratorName is null");
            }
            for (String oneInvolved : arraySourcingInvolved = sourcingInvolved.split(",", -1)) {
                User userForSI = us.getUser(oneInvolved, new String[0]);
                String oneInvolvedName = "";
                if (userForSI != null) {
                    oneInvolvedName = userForSI.getFullName();
                }
                if (oneInvolvedName == null || oneInvolvedName.compareTo(oneInvolved) == 0) continue;
                listSourcingInvolved.add(oneInvolved);
            }
            if (sourcingAdministratorName != null && ((String)sourcingAdministratorName).compareTo(sourcingAdministrator) != 0 && listSourcingInvolved.size() != 0) break;
            sourcingInvolved = "";
            sourcingAdministrator = "";
            log.debug((Object)("sourcingAdministrator" + sourcingAdministrator));
        }
        if (sourcingAdministrator == null || sourcingAdministrator.compareTo("") == 0 || listSourcingInvolved.size() == 0) {
            log.debug((Object)("listSourcingInvolved.size()" + listSourcingInvolved.size()));
            String sError = "There is no assignment to task 'Sourcing' or 'Delegate sourcing' for product line ".concat(product_line).concat(". Contact system administrator.");
            throw new Exception(sError);
        }
        String sciezkaPlik1 = null;
        String sciezkaPlik2 = null;
        if (VTable.exists((String)"tab_files") && VColumn.exists((String)"tab_files", (String)"col_file_name") && VColumn.exists((String)"tab_files", (String)"col_file_path")) {
            ArrayList listOfRecords = VRecord.getRecordsWhere((String)"tab_files", (String)"col_file_name", (String)"Items");
            for (Record rec : listOfRecords) {
                sciezkaPlik1 = (String)rec.getValue("col_file_path");
            }
            listOfRecords = VRecord.getRecordsWhere((String)"tab_files", (String)"col_file_name", (String)"Employees");
            for (Record rec : listOfRecords) {
                sciezkaPlik2 = (String)rec.getValue("col_file_path");
            }
        }
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Item");
        columns.add("Ordering");
        columns.add("Buy from");
        ArrayList<Map<String, String>> itemsList = P0045eoSourcingAssignments.getDataFromExcelFile(sciezkaPlik1, columns);
        columns = new ArrayList();
        columns.add("Employee");
        columns.add("Logonc Cde");
        ArrayList<Map<String, String>> employeesList = P0045eoSourcingAssignments.getDataFromExcelFile(sciezkaPlik2, columns);
        if (itemsList == null || employeesList == null) {
            throw new Exception("One of required files doesn't exist on server.");
        }
        log.debug((Object)"Items list size: ".concat(String.valueOf(itemsList.size())));
        log.debug((Object)"Employees list size: ".concat(String.valueOf(employeesList.size())));
        ArrayList<Map<String, String>> itemEmployeeList = P0045eoSourcingAssignments.mergeListsIntoOne(itemsList, employeesList);
        log.debug((Object)"Marged list size: ".concat(String.valueOf(itemEmployeeList.size())));
        List processTable = DynamicTableFunctions.convertFromMapToListOfMaps(processContext, (String[])COL_IDS);
        for (Map oneRow : processTable) {
            String new_item = (String)oneRow.get("new_item");
            String row_sourcing_needed = (String)oneRow.get("sourcing_needed");
            if (new_item.compareTo("No") != 0 || row_sourcing_needed.compareTo("No") == 0) continue;
            boolean assignmentFound = false;
            String item_no = (String)oneRow.get("new_item_no");
            String type_of_purchase = (String)oneRow.get("type_of_purchase");
            if (type_of_purchase.compareTo("Purchase below") == 0) {
                item_no = (String)oneRow.get("belongs_to");
            }
            for (Map<String, String> itemEmployee : itemEmployeeList) {
                String itemEmployee_no = itemEmployee.get("item_no");
                if (item_no.compareTo(itemEmployee_no) != 0) continue;
                oneRow.put("vendor_no", itemEmployee.get("vendor_no"));
                oneRow.put("vendor_name", itemEmployee.get("vendor_name"));
                String itemEmployee_employee = itemEmployee.get("item_owner");
                boolean productLineOk = false;
                for (String involved : listSourcingInvolved) {
                    if (involved.compareTo(itemEmployee_employee) != 0) continue;
                    productLineOk = true;
                    break;
                }
                if (productLineOk) {
                    oneRow.put("responsible_sourcing_login", itemEmployee_employee);
                    oneRow.put("responsible_sourcing", itemEmployee.get("item_owner_name"));
                    assignmentFound = true;
                    log.debug((Object)"U\u017cytkownik ".concat(itemEmployee_employee).concat(" przypisany do itemu ").concat(item_no));
                    break;
                }
                log.debug((Object)"Osoba ".concat(itemEmployee_employee).concat(" nie jest przypisana do tego product item."));
                break;
            }
            if (assignmentFound || listSourcingInvolved.size() != 1) continue;
            oneRow.put("responsible_sourcing_login", (String)listSourcingInvolved.get(0));
            oneRow.put("responsible_sourcing", Tools.GetRealUserName((String)((String)listSourcingInvolved.get(0))));
        }
        processContext.put("akcja", "delegate_sourcing");
        processContext.put("assignment_sourcing", sourcingAdministrator);
        Map processTableMap = DynamicTableFunctions.convertFromListOfMapsToMap((List)processTable, (String[])COL_IDS);
        for (int i = 0; i < COL_IDS.length; ++i) {
            processContext.put(COL_IDS[i], processTableMap.get(COL_IDS[i]));
        }
        log.trace((Object)"*************** eo.P0045eoLogisticAssignments finished ********");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<Map<String, String>> mergeListsIntoOne(ArrayList<Map<String, String>> itemsList, ArrayList<Map<String, String>> employeesList) {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        block11: for (Map<String, String> item : itemsList) {
            String itemNo = item.get("Item").trim();
            String itemOwner = item.get("Ordering").trim();
            String vendorNo = item.get("Buy from").trim();
            String vendorName = "";
            if (vendorNo.compareTo("") != 0) {
                Connection conn = null;
                try {
                    conn = InternalDataBase.connect();
                    String temp_query = "SELECT DISTINCT bp_partner as vendor_no, bp_name as vendor_name FROM pm_cust_kontrahenci WHERE bp_partner = '@vendor_no@'";
                    String query = temp_query.replace("@vendor_no@", vendorNo);
                    ArrayList listOfResults = InternalDataBase.executeQuery((Connection)conn, (String)query);
                    if (listOfResults.size() == 1) {
                        vendorName = (String)((HashMap)listOfResults.get(0)).get("vendor_name");
                    } else {
                        vendorNo = "";
                        log.info((Object)"Nie znaleziono w systemie dostawcy podanego w pliku Excel: ".concat(vendorNo));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"B\u0142\u0105d wyszukiwania kontrahent\u00f3w.");
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    if (conn != null) {
                        try {
                            InternalDataBase.distconnect((Connection)conn);
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            HashMap<String, String> oneResult = new HashMap<String, String>();
            for (Map<String, String> employee : employeesList) {
                String employeeName;
                String employeeCode = employee.get("Employee").trim();
                if (employeeCode.compareTo(itemOwner) != 0) continue;
                String employeeLogin = "mcint/".concat(employee.get("Logonc Cde"));
                if (employeeLogin.compareTo(employeeName = Tools.GetRealUserName((String)employeeLogin)) != 0) {
                    oneResult.put("item_no", itemNo);
                    oneResult.put("item_owner", employeeLogin);
                    oneResult.put("item_owner_name", employeeName);
                    oneResult.put("vendor_no", vendorNo);
                    oneResult.put("vendor_name", vendorName);
                    results.add(oneResult);
                    continue block11;
                }
                log.info((Object)"U\u017cytkownik znaleziony w pliku nie istnieje w systemie: ".concat(employeeLogin));
                continue block11;
            }
        }
        return results;
    }

    private static ArrayList<Map<String, String>> getDataFromExcelFile(String filePath, ArrayList<String> columns) {
        ArrayList<Map<String, String>> listOfRows = null;
        if (filePath != null && filePath.compareTo("") != 0) {
            listOfRows = P0045Tools.importDataFromXlsxFile(filePath, columns, 0);
        }
        return listOfRows;
    }
}

