/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.eo;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.plugin.P0045Tools;
import com.suncode.plugin.eo.DynamicTableColumns;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class P0045eoLogisticAssignments {
    public static Logger log = Logger.getLogger(P0045eoLogisticAssignments.class);

    public static void setLogisticAssignments(Map<String, Object> processContext) throws Exception {
        log.trace((Object)"*************** eo.P0045eoLogisticAssignments ********");
        String[] COL_IDS = DynamicTableColumns.getColumns();
        UserService us = ServiceFactory.getUserService();
        String logistic_needed = (String)processContext.get("logistic_needed");
        boolean isNeeded = false;
        if (logistic_needed != null && logistic_needed.compareTo("") != 0) {
            String[] tempLogistic;
            for (String temp : tempLogistic = logistic_needed.split(";", -1)) {
                if (temp.compareTo("") != 0 && temp.compareTo("Yes") != 0) continue;
                isNeeded = true;
                break;
            }
        } else {
            isNeeded = true;
        }
        if (((String)processContext.get("new_item")).indexOf("Yes") >= 0) {
            isNeeded = true;
        }
        if (isNeeded) {
            String product_line = (String)processContext.get("product_line");
            String[] listOfInvolved = null;
            String logisticAdministrator = null;
            SQLFinder finder = FinderFactory.getSQLFinder();
            SQLBuilder builder = new SQLBuilder();
            String sQuery = "SELECT col_involved, col_administrator FROM pm_cust_product_lines";
            builder.setQuery(sQuery);
            builder.addScalar("col_involved", (Type)StandardBasicTypes.STRING);
            builder.addScalar("col_administrator", (Type)StandardBasicTypes.STRING);
            builder.addFilter((SQLFilter)new SimpleSQLFilter("col_product_line", (Object)product_line, FilterOperator.EQ));
            log.debug((Object)("sQuery: " + sQuery));
            List data = finder.find(builder);
            for (Map rec : data) {
                String involvedList = (String)rec.get("col_involved");
                if (involvedList == null || involvedList.compareTo("") == 0) continue;
                listOfInvolved = involvedList.split(",");
                logisticAdministrator = (String)rec.get("col_administrator");
            }
            if (listOfInvolved == null) {
                throw new Exception("Noone is assigned to choosen product line.");
            }
            if (logisticAdministrator == null || logisticAdministrator.compareTo("") == 0) {
                throw new Exception("Noone is assigned as Logistic Administrator of choosen product line.");
            }
            String realname = us.getUser(logisticAdministrator, new String[0]).getFullName();
            if (realname.compareTo(logisticAdministrator) == 0) {
                throw new Exception("Logistic Administrator is not defined correctly. User ".concat(logisticAdministrator).concat(" is not defined in system."));
            }
            String sciezkaPlik1 = null;
            String sciezkaPlik2 = null;
            SQLBuilder builder2 = new SQLBuilder();
            String sQueryFiles = "SELECT col_file_name, col_file_path FROM pm_cust_files";
            builder2.setQuery(sQueryFiles);
            builder2.addScalar("col_file_name", (Type)StandardBasicTypes.STRING);
            builder2.addScalar("col_file_path", (Type)StandardBasicTypes.STRING);
            builder2.addFilter((SQLFilter)new SimpleSQLFilter("col_file_name", (Object)"Items", FilterOperator.EQ));
            log.debug((Object)("sQuery: " + sQuery));
            List listOfRecords = finder.find(builder2);
            for (Object rec : listOfRecords) {
                sciezkaPlik1 = (String)rec.get("col_file_path");
            }
            SQLBuilder builder3 = new SQLBuilder();
            builder3.setQuery(sQueryFiles);
            builder3.addScalar("col_file_name", (Type)StandardBasicTypes.STRING);
            builder3.addScalar("col_file_path", (Type)StandardBasicTypes.STRING);
            builder3.addFilter((SQLFilter)new SimpleSQLFilter("col_file_name", (Object)"Employees", FilterOperator.EQ));
            listOfRecords = finder.find(builder3);
            for (Map rec : listOfRecords) {
                sciezkaPlik2 = (String)rec.get("col_file_path");
            }
            ArrayList<String> columns = new ArrayList<String>();
            columns.add("Item");
            columns.add("Planner ID");
            columns.add("Actual Stock");
            ArrayList<Map<String, String>> itemsList = P0045eoLogisticAssignments.getDataFromExcelFile(sciezkaPlik1, columns);
            columns = new ArrayList();
            columns.add("Employee");
            columns.add("Logonc Cde");
            ArrayList<Map<String, String>> employeesList = P0045eoLogisticAssignments.getDataFromExcelFile(sciezkaPlik2, columns);
            if (itemsList == null || employeesList == null) {
                throw new Exception("One of required files doesn't exist on server.");
            }
            log.debug((Object)"Items list size: ".concat(String.valueOf(itemsList.size())));
            log.debug((Object)"Employees list size: ".concat(String.valueOf(employeesList.size())));
            ArrayList<Map<String, String>> itemEmployeeList = P0045eoLogisticAssignments.mergeListsIntoOne(itemsList, employeesList);
            log.debug((Object)"Marged list size: ".concat(String.valueOf(itemEmployeeList.size())));
            List processTable = DynamicTableFunctions.convertFromMapToListOfMaps(processContext, (String[])COL_IDS);
            for (Object oneRow : processTable) {
                String new_item = (String)oneRow.get("new_item");
                String row_logistic_needed = (String)oneRow.get("logistic_needed");
                log.debug((Object)(new_item + " / " + row_logistic_needed));
                if (new_item.compareTo("No") != 0) continue;
                boolean assignmentFound = false;
                String item_no = (String)oneRow.get("new_item_no");
                for (Map<String, String> itemEmployee : itemEmployeeList) {
                    String itemEmployee_no = itemEmployee.get("item_no");
                    if (item_no.compareTo(itemEmployee_no) != 0) continue;
                    oneRow.put("stock_in_mau", itemEmployee.get("stock_in_mau"));
                    String itemEmployee_employee = itemEmployee.get("item_owner");
                    boolean productLineOk = false;
                    for (String involved : listOfInvolved) {
                        if (involved.compareTo(itemEmployee_employee) != 0) continue;
                        productLineOk = true;
                        break;
                    }
                    if (productLineOk) {
                        oneRow.put("responsible_logistics_login", itemEmployee_employee);
                        oneRow.put("responsible_logistics", itemEmployee.get("item_owner_name"));
                        assignmentFound = true;
                        log.debug((Object)"U\u017cytkownik ".concat(itemEmployee_employee).concat(" przypisany do itemu ").concat(item_no));
                        break;
                    }
                    log.debug((Object)"Osoba ".concat(itemEmployee_employee).concat(" nie jest przypisana do tego product item."));
                    break;
                }
                if (assignmentFound || listOfInvolved.length != 1) continue;
                User involved = us.getUser(listOfInvolved[0], new String[0]);
                String userFullName = "";
                if (involved != null) {
                    userFullName = involved.getFullName();
                }
                oneRow.put("responsible_logistics_login", listOfInvolved[0]);
                oneRow.put("responsible_logistics", userFullName);
            }
            boolean isUnassigned = false;
            for (Map oneRow : processTable) {
                String new_item = (String)oneRow.get("new_item");
                String material_planner_needed = (String)oneRow.get("material_planner_needed");
                if (new_item.compareTo("No") != 0) {
                    log.debug((Object)"Podproces lokalizacji.");
                    isUnassigned = true;
                    break;
                }
                if (new_item.compareTo("No") != 0 || material_planner_needed.compareTo("No") == 0) continue;
                String responsible = (String)oneRow.get("responsible_logistics_login");
                if (responsible.compareTo("") == 0) {
                    log.debug((Object)"Istnieje nieprzypisana linia.");
                    isUnassigned = true;
                    break;
                }
                String type = (String)oneRow.get("type_of_purchase");
                if (type.compareTo("Manufactured") != 0) continue;
                log.debug((Object)"Istnieje linia typu Manufactured.");
                isUnassigned = true;
                break;
            }
            if (isUnassigned) {
                processContext.put("logistic_administrator", logisticAdministrator);
                processContext.put("akcja", "delegate_logistic");
                log.debug((Object)"Proces g\u0142\u00f3wny b\u0119dzie przekazany do Delegate logistics.");
            } else {
                processContext.put("akcja", "logistic_subprocesses");
                log.debug((Object)"Proces g\u0142\u00f3wny b\u0119dzie przekazany do Logistics subprocesses.");
            }
            Map processTableMap = DynamicTableFunctions.convertFromListOfMapsToMap((List)processTable, (String[])COL_IDS);
            for (int i = 0; i < COL_IDS.length; ++i) {
                processContext.put(COL_IDS[i], processTableMap.get(COL_IDS[i]));
            }
        } else {
            processContext.put("akcja", "update_control_plans");
            log.debug((Object)"Proces g\u0142\u00f3wny b\u0119dzie przekazany do Update control plans.");
        }
        log.trace((Object)"*************** eo.P0045eoLogisticAssignments finished ********");
    }

    private static ArrayList<Map<String, String>> mergeListsIntoOne(ArrayList<Map<String, String>> itemsList, ArrayList<Map<String, String>> employeesList) {
        UserService us = ServiceFactory.getUserService();
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        block0: for (Map<String, String> item : itemsList) {
            String itemNo = item.get("Item").trim();
            String itemOwner = item.get("Planner ID").trim();
            String stock = item.get("Actual Stock").trim();
            HashMap<String, String> oneResult = new HashMap<String, String>();
            for (Map<String, String> employee : employeesList) {
                String employeeName;
                String employeeCode = employee.get("Employee").trim();
                if (employeeCode.compareTo(itemOwner) != 0) continue;
                String employeeLogin = "mcint/".concat(employee.get("Logonc Cde"));
                if (employeeLogin.compareTo(employeeName = us.getUser(employeeLogin, new String[0]).getFullName()) != 0) {
                    oneResult.put("item_no", itemNo);
                    oneResult.put("item_owner", employeeLogin);
                    oneResult.put("item_owner_name", employeeName);
                    oneResult.put("stock_in_mau", stock);
                    results.add(oneResult);
                    continue block0;
                }
                log.info((Object)"U\u017cytkownik znaleziony w pliku nie istnieje w systemie: ".concat(employeeLogin));
                continue block0;
            }
        }
        return results;
    }

    private static ArrayList<Map<String, String>> getDataFromExcelFile(String filePath, ArrayList<String> columns) {
        ArrayList<Map<String, String>> listOfRows = null;
        if (filePath != null && filePath.compareTo("") != 0) {
            listOfRows = P0045Tools.importDataFromXlsxFile(filePath, columns, 0);
        }
        return listOfRows;
    }
}

